/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.ListConfig;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfig;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfigAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@RunAsync
@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"list", "listplayers", "ls"})
@EssentialsEquivalent(value={"list", "who", "playerlist", "online", "plist"})
public class ListPlayerCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private ListConfig listConfig = new ListConfig();
    @Nullable
    private AFKHandler handler;
    private final Text afk;
    private final Text hidden;
    public static final Function<Subject, Integer> weightingFunction = s -> Util.getIntOptionFromSubject(s, "nucleus.list.weight").orElse(0);

    public ListPlayerCommand() {
        Nucleus plugin = Nucleus.getNucleus();
        this.afk = plugin.getMessageProvider().getTextMessageWithFormat("command.list.afk", new String[0]);
        this.hidden = plugin.getMessageProvider().getTextMessageWithFormat("command.list.hidden", new String[0]);
        this.handler = plugin.getInternalServiceManager().getService(AFKHandler.class).orElse(null);
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("seevanished", PermissionInformation.getWithTranslation("permission.list.seevanished", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        boolean showVanished = this.permissions.testSuffix((Subject)src, "seevanished");
        Collection players = Sponge.getServer().getOnlinePlayers();
        long playerCount = players.size();
        long hiddenCount = players.stream().filter(x -> x.get(Keys.VANISH).orElse(false)).count();
        Text header = showVanished && hiddenCount > 0L ? Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.list.playercount.hidden", String.valueOf(playerCount), String.valueOf(Sponge.getServer().getMaxPlayers()), String.valueOf(hiddenCount)) : Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.list.playercount.base", String.valueOf(playerCount - hiddenCount), String.valueOf(Sponge.getServer().getMaxPlayers()));
        PaginationList.Builder builder = Util.getPaginationBuilder(src).title(header);
        Optional optPermissionService = Sponge.getServiceManager().provide(PermissionService.class);
        if (this.listConfig.isGroupByPermissionGroup() && optPermissionService.isPresent()) {
            builder.contents(this.listByPermissionGroup((PermissionService)optPermissionService.get(), players, showVanished));
        } else {
            builder.contents(this.getPlayerList(players, showVanished));
        }
        builder.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private List<Text> listByPermissionGroup(PermissionService service, Collection<Player> players, boolean showVanished) throws ReturnMessageException {
        ArrayList groups = Lists.newArrayList();
        try {
            service.getGroupSubjects().applyToAll(groups::add).get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (Nucleus.getNucleus().isDebugMode()) {
                e.printStackTrace();
            }
            throw ReturnMessageException.fromKey("command.list.permission.failed", new Object[0]);
        }
        groups.sort((x, y) -> ListPlayerCommand.groupComparison(weightingFunction, x, y));
        Map<Player, List<String>> playersToList = players.stream().collect(Collectors.toMap(x -> x, y -> Util.getParentSubjects((Subject)y).join().stream().map(Contextual::getIdentifier).collect(Collectors.toList())));
        ArrayList messages = Lists.newArrayList();
        Map<String, List<Player>> groupToPlayer = ListPlayerCommand.linkPlayersToGroups(groups, this.listConfig.getAliases(), playersToList);
        if (!playersToList.isEmpty()) {
            groupToPlayer.computeIfAbsent(this.listConfig.getDefaultGroupName(), g -> Lists.newArrayList()).addAll(playersToList.keySet());
        }
        this.listConfig.getOrder().forEach(alias -> {
            List plList = (List)groupToPlayer.get(alias);
            if (plList != null && !plList.isEmpty()) {
                this.getList(plList, showVanished, messages, (String)alias);
            }
            groupToPlayer.remove(alias);
        });
        String defaultGroupName = this.listConfig.getDefaultGroupName();
        if (this.listConfig.isUseAliasOnly()) {
            List<Player> playersLeft = groupToPlayer.entrySet().stream().flatMap(x -> ((List)x.getValue()).stream()).collect(Collectors.toList());
            if (!playersLeft.isEmpty()) {
                this.getList(playersLeft, showVanished, messages, defaultGroupName);
            }
        } else {
            groupToPlayer.entrySet().stream().filter(x -> !((List)x.getValue()).isEmpty()).filter(x -> !((String)x.getKey()).equals(this.listConfig.getDefaultGroupName())).sorted((x, y) -> ((String)x.getKey()).compareToIgnoreCase((String)y.getKey())).forEach(x -> this.getList((Collection)x.getValue(), showVanished, messages, (String)x.getKey()));
            List<Player> pl = groupToPlayer.get(defaultGroupName);
            if (pl != null && !pl.isEmpty()) {
                this.getList(pl, showVanished, messages, defaultGroupName);
            }
        }
        return messages;
    }

    @Override
    public void onReload() {
        this.listConfig = ((PlayerInfoConfig)((PlayerInfoConfigAdapter)this.getServiceUnchecked(PlayerInfoConfigAdapter.class)).getNodeOrDefault()).getList();
    }

    public static Map<String, List<Player>> linkPlayersToGroups(List<Subject> groups, Map<String, String> groupAliases, Map<Player, List<String>> players) {
        HashMap groupToPlayer = Maps.newHashMap();
        for (Subject x : groups) {
            Collection cp;
            String groupName = x.getIdentifier();
            if (groupAliases.containsKey(x.getIdentifier())) {
                groupName = groupAliases.get(x.getIdentifier());
            }
            if ((cp = (Collection)players.entrySet().stream().filter(k -> ((List)k.getValue()).contains(x.getIdentifier())).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) continue;
            List groupPlayerList = groupToPlayer.computeIfAbsent(groupName, g -> Lists.newArrayList());
            cp.forEach(players::remove);
            groupPlayerList.addAll(cp);
        }
        return groupToPlayer;
    }

    public static int groupComparison(Function<Subject, Integer> weightingFunction, Subject x, Subject y) {
        int res = weightingFunction.apply(y) - weightingFunction.apply(x);
        if (res == 0) {
            return y.getParents().size() - x.getParents().size();
        }
        return res;
    }

    private void getList(Collection<Player> player, boolean showVanished, List<Text> messages, @Nullable String groupName) {
        List<Text> m = this.getPlayerList(player, showVanished);
        if (this.listConfig.isCompact()) {
            boolean isFirst = true;
            for (Text y : m) {
                Text.Builder tb = Text.builder();
                if (isFirst && groupName != null) {
                    tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, groupName, ": "})});
                }
                isFirst = false;
                messages.add(tb.append(new Text[]{y}).build());
            }
        } else {
            if (groupName != null) {
                messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, groupName, ":"}));
            }
            messages.addAll(m);
        }
    }

    private List<Text> getPlayerList(Collection<Player> playersToList, boolean showVanished) {
        NucleusTextTemplate template = this.listConfig.getListTemplate();
        List<Text> playerList = playersToList.stream().filter(x -> showVanished || x.get(Keys.VANISH).orElse(false) == false).sorted((x, y) -> x.getName().compareToIgnoreCase(y.getName())).map(x -> {
            Text.Builder tb = Text.builder();
            boolean appendSpace = false;
            if (this.handler != null && this.handler.isAFK((Player)x)) {
                tb.append(new Text[]{this.afk});
                appendSpace = true;
            }
            if (x.get(Keys.VANISH).orElse(false).booleanValue()) {
                tb.append(new Text[]{this.hidden});
                appendSpace = true;
            }
            if (appendSpace) {
                tb.append(new Text[]{Text.of((String)" ")});
            }
            if (template != null) {
                return tb.append(new Text[]{template.getForCommandSource((CommandSource)x)}).build();
            }
            return tb.append(new Text[]{Nucleus.getNucleus().getNameUtil().getName((User)x)}).build();
        }).collect(Collectors.toList());
        if (this.listConfig.isCompact() && !playerList.isEmpty()) {
            ArrayList<Text> toReturn = new ArrayList<Text>();
            List parts = Lists.partition(playerList, (int)this.listConfig.getMaxPlayersPerLine());
            for (List p : parts) {
                Text.Builder tb = Text.builder();
                boolean isFirst = true;
                for (Text text : p) {
                    if (!isFirst) {
                        tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.WHITE, ", "})});
                    }
                    tb.append(new Text[]{text});
                    isFirst = false;
                }
                toReturn.add(tb.build());
            }
            return toReturn;
        }
        return playerList;
    }
}

