/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.servershop.services;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.service.NucleusServerShopService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@APIService(value=NucleusServerShopService.class)
@NonnullByDefault
public class ItemWorthService
implements NucleusServerShopService,
ServiceBase {
    @Override
    public Map<CatalogType, Double> getBuyPrices() {
        return Nucleus.getNucleus().getItemDataService().getServerBuyPrices();
    }

    @Override
    public Map<CatalogType, Double> getSellPrices() {
        return Nucleus.getNucleus().getItemDataService().getServerSellPrices();
    }

    @Override
    public Optional<Double> getBuyPrice(BlockState type) throws NucleusException {
        Preconditions.checkNotNull((Object)type);
        return this.getFromBlockState(type, x -> this.getBuyPrice(x.createSnapshot()));
    }

    @Override
    public Optional<Double> getBuyPrice(ItemStackSnapshot itemStackSnapshot) {
        Preconditions.checkNotNull((Object)itemStackSnapshot);
        double price = Nucleus.getNucleus().getItemDataService().getDataForItem(itemStackSnapshot).getServerBuyPrice();
        if (price < 0.0) {
            return Optional.empty();
        }
        return Optional.of(price);
    }

    @Override
    public Optional<Double> getSellPrice(BlockState type) throws NucleusException {
        Preconditions.checkNotNull((Object)type);
        return this.getFromBlockState(type, x -> this.getSellPrice(x.createSnapshot()));
    }

    @Override
    public Optional<Double> getSellPrice(ItemStackSnapshot itemStackSnapshot) {
        Preconditions.checkNotNull((Object)itemStackSnapshot);
        double price = Nucleus.getNucleus().getItemDataService().getDataForItem(itemStackSnapshot).getServerSellPrice();
        if (price < 0.0) {
            return Optional.empty();
        }
        return Optional.of(price);
    }

    private Tuple<Optional<BlockState>, ItemType> getType(DataHolder stack, ItemType type) {
        return Tuple.of((Object)stack.get(Keys.ITEM_BLOCKSTATE), (Object)type);
    }

    private Optional<Double> getFromBlockState(BlockState type, Function<ItemStack, Optional<Double>> transform) throws NucleusException {
        return transform.apply(type.getType().getItem().map(x -> {
            ItemStack stack = ItemStack.of((ItemType)x, (int)1);
            if (stack.offer(Keys.ITEM_BLOCKSTATE, (Object)type).isSuccessful()) {
                return stack;
            }
            return null;
        }).orElseThrow(() -> new NucleusException((Text)Text.of((String)"That BlockState does not map to an item!"), NucleusException.ExceptionType.DOES_NOT_EXIST)));
    }
}

