/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumicenergistics.client.gui.GuiBase;

public class PacketSettingChange
implements IMessage {
    private String setting;
    private String value;

    public PacketSettingChange() {
    }

    public PacketSettingChange(Settings setting, Enum value) {
        this(setting.name(), value.name());
    }

    public PacketSettingChange(String s, String v) {
        this.setting = s;
        this.value = v;
    }

    public void fromBytes(ByteBuf buf) {
        this.setting = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.value = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.setting);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.value);
    }

    public Settings getSetting() {
        return Settings.valueOf((String)this.setting);
    }

    public Enum getValue() {
        for (Enum e : this.getSetting().getPossibleValues()) {
            if (!e.name().equalsIgnoreCase(this.value)) continue;
            return e;
        }
        return null;
    }

    public static class HandlerClient
    implements IMessageHandler<PacketSettingChange, IMessage> {
        public IMessage onMessage(PacketSettingChange message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                if (gui instanceof GuiBase) {
                    ((GuiBase)gui).updateSetting(message.getSetting(), message.getValue());
                }
            });
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<PacketSettingChange, IMessage> {
        public IMessage onMessage(PacketSettingChange message, MessageContext ctx) {
            NetHandlerPlayServer handler = ctx.getServerHandler();
            EntityPlayerMP player = handler.field_147369_b;
            IThreadListener thread = (IThreadListener)player.field_70170_p;
            thread.func_152344_a(() -> {
                IConfigManager cm;
                if (player.field_71070_bA instanceof IConfigurableObject && (cm = ((IConfigurableObject)player.field_71070_bA).getConfigManager()) != null) {
                    cm.putSetting(message.getSetting(), message.getValue());
                }
            });
            return null;
        }
    }
}

