/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.PatternMatchingCommandElement;
import org.spongepowered.api.command.args.SelectorCommandElement;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.command.source.RemoteSource;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.serializer.TextParseException;
import org.spongepowered.api.text.serializer.TextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

public final class GenericArguments {
    private static final CommandElement NONE = new SequenceCommandElement((List<CommandElement>)ImmutableList.of());
    private static final Map<String, Boolean> BOOLEAN_CHOICES = ImmutableMap.builder().put((Object)"true", (Object)true).put((Object)"t", (Object)true).put((Object)"y", (Object)true).put((Object)"yes", (Object)true).put((Object)"verymuchso", (Object)true).put((Object)"1", (Object)true).put((Object)"false", (Object)false).put((Object)"f", (Object)false).put((Object)"n", (Object)false).put((Object)"no", (Object)false).put((Object)"notatall", (Object)false).put((Object)"0", (Object)false).build();

    private GenericArguments() {
    }

    public static CommandElement none() {
        return NONE;
    }

    public static CommandElement markTrue(Text key) {
        return new MarkTrueCommandElement(key);
    }

    public static CommandElement playerOrSource(Text key) {
        return new PlayerCommandElement(key, true);
    }

    public static CommandElement player(Text key) {
        return new PlayerCommandElement(key, false);
    }

    public static CommandElement user(Text key) {
        return new UserCommandElement(key, false);
    }

    public static CommandElement userOrSource(Text key) {
        return new UserCommandElement(key, true);
    }

    public static CommandElement world(Text key) {
        return new WorldPropertiesCommandElement(key);
    }

    public static CommandElement dimension(Text key) {
        return GenericArguments.catalogedElement(key, DimensionType.class);
    }

    public static CommandElement vector3d(Text key) {
        return new Vector3dCommandElement(key);
    }

    public static CommandElement location(Text key) {
        return new LocationCommandElement(key);
    }

    public static <T extends CatalogType> CommandElement catalogedElement(Text key, Class<T> catalogType) {
        return new CatalogedTypeCommandElement<T>(key, catalogType);
    }

    public static CommandElement plugin(Text key) {
        return new PluginCommandElement(key);
    }

    public static CommandFlags.Builder flags() {
        return new CommandFlags.Builder();
    }

    public static CommandElement seq(CommandElement ... elements) {
        return new SequenceCommandElement((List<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement choices(Text key, Map<String, ?> choices) {
        return GenericArguments.choices(key, choices, choices.size() <= 5, true);
    }

    public static CommandElement choicesInsensitive(Text key, Map<String, ?> choices) {
        return GenericArguments.choices(key, choices, choices.size() <= 5, false);
    }

    public static CommandElement choices(Text key, Map<String, ?> choices, boolean choicesInUsage) {
        return GenericArguments.choices(key, choices, choicesInUsage, true);
    }

    public static CommandElement choices(Text key, Map<String, ?> choices, boolean choicesInUsage, boolean caseSensitive) {
        if (!caseSensitive) {
            Map immChoices = (Map)choices.entrySet().stream().collect(ImmutableMap.toImmutableMap(x -> ((String)x.getKey()).toLowerCase(), Map.Entry::getValue));
            return GenericArguments.choices(key, immChoices::keySet, selection -> immChoices.get(selection.toLowerCase()), choicesInUsage);
        }
        ImmutableMap immChoices = ImmutableMap.copyOf(choices);
        return GenericArguments.choices(key, ((Map)immChoices)::keySet, ((Map)immChoices)::get, choicesInUsage);
    }

    public static CommandElement choices(Text key, Supplier<Collection<String>> keys, Function<String, ?> values) {
        return new ChoicesCommandElement(key, keys, values, Tristate.UNDEFINED);
    }

    public static CommandElement choices(Text key, Supplier<Collection<String>> keys, Function<String, ?> values, boolean choicesInUsage) {
        return new ChoicesCommandElement(key, keys, values, choicesInUsage ? Tristate.TRUE : Tristate.FALSE);
    }

    public static CommandElement firstParsing(CommandElement ... elements) {
        return new FirstParsingCommandElement((List<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement optional(CommandElement element) {
        return new OptionalCommandElement(element, null, false);
    }

    public static CommandElement optional(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, false);
    }

    public static CommandElement optionalWeak(CommandElement element) {
        return new OptionalCommandElement(element, null, true);
    }

    public static CommandElement optionalWeak(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, true);
    }

    public static CommandElement repeated(CommandElement element, int times) {
        return new RepeatedCommandElement(element, times);
    }

    public static CommandElement allOf(CommandElement element) {
        return new AllOfCommandElement(element);
    }

    public static CommandElement string(Text key) {
        return new StringElement(key);
    }

    public static CommandElement integer(Text key) {
        return new NumericElement<Integer>(key, Integer::parseInt, Integer::parseInt, input -> SpongeApiTranslationHelper.t("Expected an integer, but input '%s' was not", input));
    }

    public static CommandElement longNum(Text key) {
        return new NumericElement<Long>(key, Long::parseLong, Long::parseLong, input -> SpongeApiTranslationHelper.t("Expected a long, but input '%s' was not", input));
    }

    public static CommandElement doubleNum(Text key) {
        return new NumericElement<Double>(key, Double::parseDouble, null, input -> SpongeApiTranslationHelper.t("Expected a number, but input '%s' was not", input));
    }

    public static CommandElement bool(Text key) {
        return GenericArguments.choices(key, BOOLEAN_CHOICES);
    }

    public static <T extends Enum<T>> CommandElement enumValue(Text key, Class<T> type) {
        return new EnumValueElement<T>(key, type);
    }

    public static CommandElement remainingJoinedStrings(Text key) {
        return new RemainingJoinedStringsCommandElement(key, false);
    }

    public static CommandElement remainingRawJoinedStrings(Text key) {
        return new RemainingJoinedStringsCommandElement(key, true);
    }

    public static CommandElement literal(Text key, String ... expectedArgs) {
        return new LiteralCommandElement(key, (List<String>)ImmutableList.copyOf((Object[])expectedArgs), true);
    }

    public static CommandElement literal(Text key, @Nullable Object putValue, String ... expectedArgs) {
        return new LiteralCommandElement(key, (List<String>)ImmutableList.copyOf((Object[])expectedArgs), putValue);
    }

    public static CommandElement onlyOne(CommandElement element) {
        return new OnlyOneCommandElement(element);
    }

    public static CommandElement requiringPermission(CommandElement element, String permission) {
        return new PermissionCommandElement(element, permission);
    }

    public static CommandElement entity(Text key) {
        return new EntityCommandElement(key, false, false, (EntityType)null);
    }

    public static CommandElement entity(Text key, Class<? extends Entity> clazz) {
        return new EntityCommandElement(key, false, false, clazz);
    }

    public static CommandElement entity(Text key, EntityType type) {
        return new EntityCommandElement(key, false, false, type);
    }

    public static CommandElement entityOrSource(Text key) {
        return new EntityCommandElement(key, true, false, (EntityType)null);
    }

    public static CommandElement entityOrTarget(Text key) {
        return new EntityCommandElement(key, false, true, (EntityType)null);
    }

    public static CommandElement entityOrTarget(Text key, Class<? extends Entity> clazz) {
        return new EntityCommandElement(key, false, true, clazz);
    }

    public static CommandElement entityOrTarget(Text key, EntityType type) {
        return new EntityCommandElement(key, false, true, type);
    }

    public static CommandElement url(Text key) {
        return new UrlElement(key);
    }

    public static CommandElement ip(Text key) {
        return new IpElement(key, false);
    }

    public static CommandElement ipOrSource(Text key) {
        return new IpElement(key, true);
    }

    public static CommandElement bigDecimal(Text key) {
        return new BigDecimalElement(key);
    }

    public static CommandElement bigInteger(Text key) {
        return new BigIntegerElement(key);
    }

    public static CommandElement dataContainer(Text key) {
        return new DataElement(key);
    }

    public static CommandElement uuid(Text key) {
        return new UuidElement(key);
    }

    public static CommandElement text(Text key, TextSerializer serializer, boolean allRemaining) {
        return new TextCommandElement(key, serializer, allRemaining);
    }

    public static CommandElement dateTime(Text key) {
        return new DateTimeElement(key, false);
    }

    public static CommandElement dateTimeOrNow(Text key) {
        return new DateTimeElement(key, true);
    }

    public static CommandElement duration(Text key) {
        return new DurationElement(key);
    }

    public static CommandElement withSuggestions(CommandElement argument, Iterable<String> suggestions) {
        return GenericArguments.withSuggestions(argument, suggestions, true);
    }

    public static CommandElement withSuggestions(CommandElement argument, Iterable<String> suggestions, boolean requireBegin) {
        return GenericArguments.withSuggestions(argument, (CommandSource s) -> suggestions, requireBegin);
    }

    public static CommandElement withSuggestions(CommandElement argument, Function<CommandSource, Iterable<String>> suggestions) {
        return GenericArguments.withSuggestions(argument, suggestions, true);
    }

    public static CommandElement withSuggestions(CommandElement argument, Function<CommandSource, Iterable<String>> suggestions, boolean requireBegin) {
        return new WithSuggestionsElement(argument, suggestions, requireBegin);
    }

    public static CommandElement withConstrainedSuggestions(CommandElement argument, Predicate<String> predicate) {
        return new FilteredSuggestionsElement(argument, predicate);
    }

    private static class FilteredSuggestionsElement
    extends CommandElement {
        private final CommandElement wrapped;
        private final Predicate<String> predicate;

        protected FilteredSuggestionsElement(CommandElement wrapped, Predicate<String> predicate) {
            super(wrapped.getKey());
            this.wrapped = wrapped;
            this.predicate = predicate;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return this.wrapped.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return (List)this.wrapped.complete(src, args, context).stream().filter(this.predicate).collect(ImmutableList.toImmutableList());
        }
    }

    private static class WithSuggestionsElement
    extends CommandElement {
        private final CommandElement wrapped;
        private final Function<CommandSource, Iterable<String>> suggestions;
        private final boolean requireBegin;

        protected WithSuggestionsElement(CommandElement wrapped, Function<CommandSource, Iterable<String>> suggestions, boolean requireBegin) {
            super(wrapped.getKey());
            this.wrapped = wrapped;
            this.suggestions = suggestions;
            this.requireBegin = requireBegin;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return this.wrapped.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            if (this.requireBegin) {
                String arg = args.nextIfPresent().orElse("");
                return ImmutableList.copyOf((Iterable)Iterables.filter(this.suggestions.apply(src), f -> f.startsWith(arg)));
            }
            return ImmutableList.copyOf(this.suggestions.apply(src));
        }
    }

    private static class DurationElement
    extends KeyElement {
        protected DurationElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String s = args.next().toUpperCase();
            if (!s.contains("T")) {
                if (s.contains("D")) {
                    if (s.contains("H") || s.contains("M") || s.contains("S")) {
                        s = s.replace("D", "DT");
                    }
                } else {
                    s = s.startsWith("P") ? "PT" + s.substring(1) : "T" + s;
                }
            }
            if (!s.startsWith("P")) {
                s = "P" + s;
            }
            try {
                return Duration.parse(s);
            }
            catch (DateTimeParseException ex) {
                throw args.createError(Text.of("Invalid duration!"));
            }
        }
    }

    private static class DateTimeElement
    extends CommandElement {
        private final boolean returnNow;

        protected DateTimeElement(Text key, boolean returnNow) {
            super(key);
            this.returnNow = returnNow;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!args.hasNext() && this.returnNow) {
                return LocalDateTime.now();
            }
            CommandArgs.Snapshot state = args.getSnapshot();
            String date = args.next();
            try {
                return LocalDateTime.parse(date);
            }
            catch (DateTimeParseException ex) {
                try {
                    return LocalDateTime.of(LocalDate.now(), LocalTime.parse(date));
                }
                catch (DateTimeParseException ex2) {
                    try {
                        return LocalDateTime.of(LocalDate.parse(date), LocalTime.MIDNIGHT);
                    }
                    catch (DateTimeParseException ex3) {
                        if (this.returnNow) {
                            args.applySnapshot(state);
                            return LocalDateTime.now();
                        }
                        throw args.createError(Text.of("Invalid date-time!"));
                    }
                }
            }
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            String date = LocalDateTime.now().withNano(0).toString();
            if (date.startsWith(args.nextIfPresent().orElse(""))) {
                return ImmutableList.of((Object)date);
            }
            return ImmutableList.of();
        }

        @Override
        public Text getUsage(CommandSource src) {
            if (!this.returnNow) {
                return super.getUsage(src);
            }
            return Text.of("[", this.getKey(), "]");
        }
    }

    private static class TextCommandElement
    extends KeyElement {
        private final TextSerializer serializer;
        private final boolean allRemaining;
        private final RemainingJoinedStringsCommandElement joinedElement;

        protected TextCommandElement(Text key, TextSerializer serializer, boolean allRemaining) {
            super(key);
            this.serializer = serializer;
            this.allRemaining = allRemaining;
            this.joinedElement = allRemaining ? new RemainingJoinedStringsCommandElement(key, false) : null;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String arg = this.allRemaining ? (String)this.joinedElement.parseValue(source, args) : args.next();
            try {
                return this.serializer.deserialize(arg);
            }
            catch (TextParseException ex) {
                if (this.serializer == TextSerializers.JSON) {
                    if (ex.getMessage() == null) {
                        throw args.createError(Text.of("Invalid JSON text!"));
                    }
                    throw args.createError(Text.of("Invalid JSON text: ", ex.getMessage()));
                }
                if (ex.getMessage() == null) {
                    throw args.createError(Text.of("Invalid text!"));
                }
                throw args.createError(Text.of("Invalid text: ", ex.getMessage()));
            }
        }
    }

    private static class UuidElement
    extends KeyElement {
        protected UuidElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            try {
                return UUID.fromString(args.next());
            }
            catch (IllegalArgumentException ex) {
                throw args.createError(Text.of("Invalid UUID!"));
            }
        }
    }

    private static class DataElement
    extends RemainingJoinedStringsCommandElement {
        protected DataElement(Text key) {
            super(key, true);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Object node;
            String argument = (String)super.parseValue(source, args);
            Callable<BufferedReader> reader = () -> new BufferedReader(new StringReader(argument));
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(reader)).build();
            try {
                node = loader.load();
            }
            catch (IOException ex) {
                throw args.createError(Text.of("Node parsing failed: ", ex.getMessage()));
            }
            return DataTranslators.CONFIGURATION_NODE.translate((ConfigurationNode)node);
        }
    }

    private static class BigIntegerElement
    extends KeyElement {
        protected BigIntegerElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String integerString = args.next();
            try {
                return new BigInteger(integerString);
            }
            catch (NumberFormatException ex) {
                throw args.createError(Text.of("Expected an integer, but input " + integerString + " was not"));
            }
        }
    }

    private static class BigDecimalElement
    extends KeyElement {
        protected BigDecimalElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String next = args.next();
            try {
                return new BigDecimal(next);
            }
            catch (NumberFormatException ex) {
                throw args.createError(Text.of("Expected a number, but input " + next + " was not"));
            }
        }
    }

    private static class IpElement
    extends KeyElement {
        private final boolean self;
        private final PlayerCommandElement possiblePlayer;

        protected IpElement(Text key, boolean self) {
            super(key);
            this.self = self;
            this.possiblePlayer = new PlayerCommandElement(key, false);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!args.hasNext() && this.self) {
                if (source instanceof RemoteSource) {
                    return ((RemoteSource)source).getConnection().getAddress().getAddress();
                }
                throw args.createError(Text.of("No IP address was specified!"));
            }
            CommandArgs.Snapshot state = args.getSnapshot();
            String s = args.next();
            try {
                return InetAddress.getByName(s);
            }
            catch (UnknownHostException e) {
                try {
                    return ((Player)this.possiblePlayer.parseValue(source, args)).getConnection().getAddress().getAddress();
                }
                catch (ArgumentParseException ex) {
                    if (this.self && source instanceof RemoteSource) {
                        args.applySnapshot(state);
                        return ((RemoteSource)source).getConnection().getAddress().getAddress();
                    }
                    throw args.createError(Text.of("Invalid IP address!"));
                }
            }
        }

        @Override
        public Text getUsage(CommandSource src) {
            return src instanceof RemoteSource && this.self ? Text.of("[", super.getUsage(src), "]") : super.getUsage(src);
        }
    }

    private static class UrlElement
    extends KeyElement {
        protected UrlElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            URL url;
            String str = args.next();
            try {
                url = new URL(str);
            }
            catch (MalformedURLException ex) {
                throw new ArgumentParseException(Text.of("Invalid URL!"), (Throwable)ex, str, 0);
            }
            try {
                url.toURI();
            }
            catch (URISyntaxException ex) {
                throw new ArgumentParseException(Text.of("Invalid URL!"), (Throwable)ex, str, 0);
            }
            return url;
        }
    }

    private static class EntityCommandElement
    extends SelectorCommandElement {
        private final boolean returnTarget;
        private final boolean returnSource;
        @Nullable
        private final Class<? extends Entity> clazz;
        @Nullable
        private final EntityType type;

        protected EntityCommandElement(Text key, boolean returnSource, boolean returnTarget, @Nullable Class<? extends Entity> clazz) {
            super(key);
            this.returnSource = returnSource;
            this.returnTarget = returnTarget;
            this.clazz = clazz;
            this.type = null;
        }

        protected EntityCommandElement(Text key, boolean returnSource, boolean returnTarget, @Nullable EntityType type) {
            super(key);
            this.returnSource = returnSource;
            this.returnTarget = returnTarget;
            this.clazz = null;
            this.type = type;
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!args.hasNext()) {
                if (this.returnSource) {
                    return this.tryReturnSource(source, args, true);
                }
                if (this.returnTarget) {
                    return this.tryReturnTarget(source, args);
                }
            }
            CommandArgs.Snapshot state = args.getSnapshot();
            try {
                Iterable entities = (Iterable)super.parseValue(source, args);
                for (Entity entity : entities) {
                    if (this.checkEntity(entity)) continue;
                    Text name = this.type == null ? Sponge.getRegistry().getAllOf(EntityType.class).stream().filter(t -> t.getEntityClass().equals(this.clazz)).findFirst().map(Translatable::getTranslation).map(x$0 -> Text.of(x$0, new Object[0])).orElse(Text.of(this.clazz.getSimpleName())) : Text.of(this.type, new Object[0]);
                    throw args.createError(Text.of("The entity is not of the required type! (", name, ")"));
                }
                return entities;
            }
            catch (ArgumentParseException ex) {
                if (this.returnSource) {
                    args.applySnapshot(state);
                    return this.tryReturnSource(source, args, true);
                }
                throw ex;
            }
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            Set<String> worldEntities = Sponge.getServer().getWorlds().stream().flatMap(x -> x.getEntities().stream()).filter(this::checkEntity).map(x -> x.getUniqueId().toString()).collect(Collectors.toSet());
            Collection<Player> players = Sponge.getServer().getOnlinePlayers();
            if (!players.isEmpty() && this.checkEntity(players.iterator().next())) {
                HashSet<String> setToReturn = new HashSet<String>(worldEntities);
                players.forEach(x -> setToReturn.add(x.getName()));
                return setToReturn;
            }
            return worldEntities;
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            UUID uuid;
            try {
                uuid = UUID.fromString(choice);
            }
            catch (IllegalArgumentException ignored) {
                return Sponge.getServer().getPlayer(choice).orElseThrow(() -> new IllegalArgumentException("Input value " + choice + " does not represent a valid entity"));
            }
            boolean found = false;
            for (World world : Sponge.getServer().getWorlds()) {
                Optional<Entity> ret = world.getEntity(uuid);
                if (!ret.isPresent()) continue;
                Entity entity = ret.get();
                if (this.checkEntity(entity)) {
                    return entity;
                }
                found = true;
            }
            if (found) {
                throw new IllegalArgumentException("Input value " + choice + " was not an entity of the required type!");
            }
            throw new IllegalArgumentException("Input value " + choice + " was not an entity");
        }

        private Entity tryReturnSource(CommandSource source, CommandArgs args, boolean check) throws ArgumentParseException {
            CommandSource proxy;
            if (source instanceof Entity && (!check || this.checkEntity((Entity)((Object)source)))) {
                return (Entity)((Object)source);
            }
            if (source instanceof ProxySource && (proxy = ((ProxySource)source).getOriginalSource()) instanceof Entity && (!check || this.checkEntity((Entity)((Object)proxy)))) {
                return (Entity)((Object)proxy);
            }
            throw args.createError(SpongeApiTranslationHelper.t("No entities matched and source was not an entity!", new Object[0]));
        }

        private Entity tryReturnTarget(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Entity entity = this.tryReturnSource(source, args, false);
            return entity.getWorld().getIntersectingEntities(entity, 10.0).stream().filter(e -> !e.getEntity().equals(entity)).map(EntityUniverse.EntityHit::getEntity).filter(this::checkEntity).findFirst().orElseThrow(() -> args.createError(SpongeApiTranslationHelper.t("No entities matched and source was not looking at a valid entity!", new Object[0])));
        }

        private boolean checkEntity(Entity entity) {
            if (this.clazz == null && this.type == null) {
                return true;
            }
            if (this.clazz == null) {
                return entity.getType().equals(this.type);
            }
            return this.clazz.isAssignableFrom(entity.getClass());
        }

        @Override
        public Text getUsage(CommandSource src) {
            return src instanceof Entity && (this.returnSource || this.returnTarget) ? Text.of("[", this.getKey(), "]") : super.getUsage(src);
        }
    }

    private static class PermissionCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final String permission;

        protected PermissionCommandElement(CommandElement element, String permission) {
            super(element.getKey());
            this.element = element;
            this.permission = permission;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            this.checkPermission(source, args);
            return this.element.parseValue(source, args);
        }

        private void checkPermission(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!source.hasPermission(this.permission)) {
                Text key = this.getKey();
                throw args.createError(SpongeApiTranslationHelper.t("You do not have permission to use the %s argument", key != null ? key : SpongeApiTranslationHelper.t("unknown", new Object[0])));
            }
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            if (!src.hasPermission(this.permission)) {
                return ImmutableList.of();
            }
            return this.element.complete(src, args, context);
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            this.checkPermission(source, args);
            this.element.parse(source, args, context);
        }

        @Override
        public Text getUsage(CommandSource src) {
            return this.element.getUsage(src);
        }
    }

    private static class OnlyOneCommandElement
    extends CommandElement {
        private final CommandElement element;

        protected OnlyOneCommandElement(CommandElement element) {
            super(element.getKey());
            this.element = element;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            this.element.parse(source, args, context);
            if (context.getAll(this.element.getUntranslatedKey()).size() > 1) {
                Text key = this.element.getKey();
                throw args.createError(SpongeApiTranslationHelper.t("Argument %s may have only one value!", key != null ? key : SpongeApiTranslationHelper.t("unknown", new Object[0])));
            }
        }

        @Override
        public Text getUsage(CommandSource src) {
            return this.element.getUsage(src);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return this.element.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return this.element.complete(src, args, context);
        }
    }

    private static class CatalogedTypeCommandElement<T extends CatalogType>
    extends PatternMatchingCommandElement {
        private final Class<T> catalogType;

        protected CatalogedTypeCommandElement(Text key, Class<T> catalogType) {
            super(key);
            this.catalogType = catalogType;
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getGame().getRegistry().getAllOf(this.catalogType).stream().map(input -> input == null ? null : input.getId()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<T> ret = Sponge.getGame().getRegistry().getType(this.catalogType, choice);
            if (!ret.isPresent()) {
                throw new IllegalArgumentException("Invalid input " + choice + " was found");
            }
            return ret.get();
        }
    }

    private static class LocationCommandElement
    extends CommandElement {
        private final WorldPropertiesCommandElement worldParser = new WorldPropertiesCommandElement(null);
        private final Vector3dCommandElement vectorParser = new Vector3dCommandElement(null);

        protected LocationCommandElement(Text key) {
            super(key);
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Object world;
            CommandArgs.Snapshot state = args.getSnapshot();
            if (args.peek().startsWith("@")) {
                return Selector.parse(args.next()).resolve(source).stream().map(Locatable::getLocation).collect(ImmutableSet.toImmutableSet());
            }
            Object vec = null;
            try {
                world = Preconditions.checkNotNull((Object)this.worldParser.parseValue(source, args), (Object)"worldVal");
            }
            catch (ArgumentParseException ex) {
                args.applySnapshot(state);
                if (!(source instanceof Locatable)) {
                    throw args.createError(SpongeApiTranslationHelper.t("Source must have a location in order to have a fallback world", new Object[0]));
                }
                world = ((Locatable)((Object)source)).getWorld().getProperties();
                try {
                    vec = Preconditions.checkNotNull((Object)this.vectorParser.parseValue(source, args), (Object)"vectorVal");
                }
                catch (ArgumentParseException ex2) {
                    args.applySnapshot(state);
                    throw ex;
                }
            }
            if (vec == null) {
                vec = Preconditions.checkNotNull((Object)this.vectorParser.parseValue(source, args), (Object)"vectorVal");
            }
            if (world instanceof Collection) {
                if (((Collection)world).size() != 1) {
                    throw args.createError(SpongeApiTranslationHelper.t("A location must be specified in only one world!", new Object[0]));
                }
                world = ((Collection)world).iterator().next();
            }
            WorldProperties targetWorldProps = (WorldProperties)world;
            Optional<World> targetWorld = Sponge.getGame().getServer().getWorld(targetWorldProps.getUniqueId());
            Vector3d vector = (Vector3d)vec;
            return new Location<Extent>((Extent)targetWorld.get(), vector);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            CommandArgs.Snapshot state = args.getSnapshot();
            Optional<String> nextPossibility = args.nextIfPresent();
            if (nextPossibility.isPresent() && nextPossibility.get().startsWith("@")) {
                return Selector.complete(nextPossibility.get());
            }
            args.applySnapshot(state);
            List<String> ret = this.worldParser.complete(src, args, context);
            if (ret.isEmpty()) {
                args.applySnapshot(state);
                ret = this.vectorParser.complete(src, args, context);
            }
            return ret;
        }
    }

    private static class Vector3dCommandElement
    extends CommandElement {
        private static final ImmutableSet<String> SPECIAL_TOKENS = ImmutableSet.of((Object)"#target", (Object)"#me");

        protected Vector3dCommandElement(@Nullable Text key) {
            super(key);
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String zStr;
            String yStr;
            String xStr = args.next();
            if (xStr.contains(",")) {
                String[] split = xStr.split(",");
                if (split.length != 3) {
                    throw args.createError(SpongeApiTranslationHelper.t("Comma-separated location must have 3 elements, not %s", split.length));
                }
                xStr = split[0];
                yStr = split[1];
                zStr = split[2];
            } else {
                if (xStr.equals("#target") && source instanceof Entity) {
                    Optional<BlockRayHit<World>> hit = BlockRay.from((Entity)((Object)source)).stopFilter(BlockRay.continueAfterFilter(BlockRay.onlyAirFilter(), 1)).build().end();
                    if (!hit.isPresent()) {
                        throw args.createError(SpongeApiTranslationHelper.t("No target block is available! Stop stargazing!", new Object[0]));
                    }
                    return hit.get().getPosition();
                }
                if (xStr.equalsIgnoreCase("#me") && source instanceof Locatable) {
                    return ((Locatable)((Object)source)).getLocation().getPosition();
                }
                yStr = args.next();
                zStr = args.next();
            }
            double x = this.parseRelativeDouble(args, xStr, source instanceof Locatable ? Double.valueOf(((Locatable)((Object)source)).getLocation().getX()) : null);
            double y = this.parseRelativeDouble(args, yStr, source instanceof Locatable ? Double.valueOf(((Locatable)((Object)source)).getLocation().getY()) : null);
            double z = this.parseRelativeDouble(args, zStr, source instanceof Locatable ? Double.valueOf(((Locatable)((Object)source)).getLocation().getZ()) : null);
            return new Vector3d(x, y, z);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            Optional<String> arg = args.nextIfPresent();
            if (arg.isPresent()) {
                if (arg.get().startsWith("#")) {
                    return (List)SPECIAL_TOKENS.stream().filter(new StartsWithPredicate(arg.get())).collect(ImmutableList.toImmutableList());
                }
                if (arg.get().contains(",") || !args.hasNext()) {
                    return ImmutableList.of((Object)arg.get());
                }
                arg = args.nextIfPresent();
                if (args.hasNext()) {
                    return ImmutableList.of((Object)args.nextIfPresent().get());
                }
                return ImmutableList.of((Object)arg.get());
            }
            return ImmutableList.of();
        }

        private double parseRelativeDouble(CommandArgs args, String arg, @Nullable Double relativeTo) throws ArgumentParseException {
            boolean relative = arg.startsWith("~");
            if (relative) {
                if (relativeTo == null) {
                    throw args.createError(SpongeApiTranslationHelper.t("Relative position specified but source does not have a position", new Object[0]));
                }
                if ((arg = arg.substring(1)).isEmpty()) {
                    return relativeTo;
                }
            }
            try {
                double ret = Double.parseDouble(arg);
                return relative ? ret + relativeTo : ret;
            }
            catch (NumberFormatException e) {
                throw args.createError(SpongeApiTranslationHelper.t("Expected input %s to be a double, but was not", arg));
            }
        }
    }

    private static class WorldPropertiesCommandElement
    extends PatternMatchingCommandElement {
        private final CommandElement dimensionTypeElement;

        protected WorldPropertiesCommandElement(@Nullable Text key) {
            super(key);
            this.dimensionTypeElement = GenericArguments.onlyOne(GenericArguments.catalogedElement(key, DimensionType.class));
        }

        @Override
        @Nullable
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String next = args.peek();
            if (next.startsWith("#")) {
                String specifier = next.substring(1);
                if (specifier.equalsIgnoreCase("first")) {
                    args.next();
                    return Sponge.getGame().getServer().getAllWorldProperties().stream().filter(input -> input != null && input.isEnabled()).collect(Collectors.toList()).iterator().next();
                }
                if (specifier.equalsIgnoreCase("me") && source instanceof Locatable) {
                    args.next();
                    return ((Locatable)((Object)source)).getWorld().getProperties();
                }
                boolean firstOnly = false;
                if (specifier.endsWith(":first")) {
                    firstOnly = true;
                    specifier = specifier.substring(0, specifier.length() - 6);
                }
                args.next();
                args.insertArg(specifier);
                DimensionType type = (DimensionType)((Iterable)this.dimensionTypeElement.parseValue(source, args)).iterator().next();
                Iterable ret = Sponge.getGame().getServer().getAllWorldProperties().stream().filter(input -> input != null && input.isEnabled() && input.getDimensionType().equals(type)).collect(Collectors.toList());
                return firstOnly ? ret.iterator().next() : ret;
            }
            return super.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            Iterable choices = this.getCompletionChoices(src);
            Optional<String> nextArg = args.nextIfPresent();
            if (nextArg.isPresent()) {
                choices = Iterables.filter(choices, input -> this.getFormattedPattern((String)nextArg.get()).matcher((CharSequence)input).find());
            }
            return ImmutableList.copyOf(choices);
        }

        protected Iterable<String> getCompletionChoices(CommandSource source) {
            return Iterables.concat(this.getChoices(source), (Iterable)ImmutableSet.of((Object)"#first", (Object)"#me"), (Iterable)Iterables.transform(Sponge.getGame().getRegistry().getAllOf(DimensionType.class), input2 -> "#" + input2.getId()));
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getGame().getServer().getAllWorldProperties().stream().map(input -> input.getWorldName()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<WorldProperties> ret = Sponge.getGame().getServer().getWorldProperties(choice);
            if (!ret.isPresent()) {
                throw new IllegalArgumentException("Provided argument " + choice + " did not match a WorldProperties");
            }
            return ret.get();
        }
    }

    private static class PlayerCommandElement
    extends SelectorCommandElement {
        private final boolean returnSource;

        protected PlayerCommandElement(Text key, boolean returnSource) {
            super(key);
            this.returnSource = returnSource;
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!args.hasNext() && this.returnSource) {
                return this.tryReturnSource(source, args);
            }
            CommandArgs.Snapshot state = args.getSnapshot();
            try {
                return Iterables.filter((Iterable)((Iterable)super.parseValue(source, args)), e -> e instanceof Player);
            }
            catch (ArgumentParseException ex) {
                if (this.returnSource) {
                    args.applySnapshot(state);
                    return this.tryReturnSource(source, args);
                }
                throw ex;
            }
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getGame().getServer().getOnlinePlayers().stream().map(input -> input == null ? null : input.getName()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<Player> ret = Sponge.getGame().getServer().getPlayer(choice);
            if (!ret.isPresent()) {
                throw new IllegalArgumentException("Input value " + choice + " was not a player");
            }
            return ret.get();
        }

        private Player tryReturnSource(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (source instanceof Player) {
                return (Player)source;
            }
            if (source instanceof ProxySource && ((ProxySource)source).getOriginalSource() instanceof Player) {
                return (Player)((ProxySource)source).getOriginalSource();
            }
            throw args.createError(SpongeApiTranslationHelper.t("No players matched and source was not a player!", new Object[0]));
        }

        @Override
        public Text getUsage(CommandSource src) {
            return src instanceof Player && this.returnSource ? Text.of("[", super.getUsage(src), "]") : super.getUsage(src);
        }
    }

    private static class UserCommandElement
    extends SelectorCommandElement {
        private final boolean returnSource;

        protected UserCommandElement(@Nullable Text key, boolean returnSource) {
            super(key);
            this.returnSource = returnSource;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            CommandArgs.Snapshot state = args.getSnapshot();
            try {
                return Iterables.filter((Iterable)((Iterable)super.parseValue(source, args)), e -> e instanceof User);
            }
            catch (ArgumentParseException ex2) {
                if (this.returnSource) {
                    args.applySnapshot(state);
                    return this.tryReturnSource(source, args);
                }
                throw ex2;
            }
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return (Iterable)Sponge.getGame().getServiceManager().provideUnchecked(UserStorageService.class).getAll().stream().map(GameProfile::getName).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            return Sponge.getGame().getServiceManager().provideUnchecked(UserStorageService.class).get(choice).orElseThrow(() -> new IllegalArgumentException("Input value '" + choice + "' was not a user!"));
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            Text key = this.getKey();
            if (key != null && !context.hasAny("tab-complete-50456")) {
                if (this.returnSource && !args.hasNext()) {
                    context.putArg(key, (Object)this.tryReturnSource(source, args));
                    return;
                }
                CommandArgs.Snapshot state = args.getSnapshot();
                String element = args.next();
                try {
                    Optional<User> match = Sponge.getServiceManager().provideUnchecked(UserStorageService.class).get(element);
                    if (match.isPresent()) {
                        context.putArg(key, (Object)match.get());
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                args.applySnapshot(state);
            }
            super.parse(source, args, context);
        }

        private User tryReturnSource(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (source instanceof User) {
                return (User)((Object)source);
            }
            if (source instanceof ProxySource && ((ProxySource)source).getOriginalSource() instanceof User) {
                return (User)((Object)((ProxySource)source).getOriginalSource());
            }
            throw args.createError(SpongeApiTranslationHelper.t("No users matched and source was not a user!", new Object[0]));
        }
    }

    private static class LiteralCommandElement
    extends CommandElement {
        private final List<String> expectedArgs;
        @Nullable
        private final Object putValue;

        protected LiteralCommandElement(@Nullable Text key, List<String> expectedArgs, @Nullable Object putValue) {
            super(key);
            this.expectedArgs = ImmutableList.copyOf(expectedArgs);
            this.putValue = putValue;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            for (String arg : this.expectedArgs) {
                String current = args.next();
                if (current.equalsIgnoreCase(arg)) continue;
                throw args.createError(SpongeApiTranslationHelper.t("Argument %s did not match expected next argument %s", current, arg));
            }
            return this.putValue;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            for (String arg : this.expectedArgs) {
                Optional<String> next = args.nextIfPresent();
                if (!next.isPresent()) break;
                if (args.hasNext()) {
                    if (next.get().equalsIgnoreCase(arg)) continue;
                    break;
                }
                if (!arg.toLowerCase().startsWith(next.get().toLowerCase())) continue;
                return ImmutableList.of((Object)arg);
            }
            return ImmutableList.of();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of(Joiner.on((char)' ').join(this.expectedArgs));
        }
    }

    private static class RemainingJoinedStringsCommandElement
    extends KeyElement {
        private final boolean raw;

        RemainingJoinedStringsCommandElement(Text key, boolean raw) {
            super(key);
            this.raw = raw;
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (this.raw) {
                args.next();
                String ret = args.getRaw().substring(args.getRawPosition());
                while (args.hasNext()) {
                    args.next();
                }
                return ret;
            }
            StringBuilder ret = new StringBuilder(args.next());
            while (args.hasNext()) {
                ret.append(' ').append(args.next());
            }
            return ret.toString();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of(CommandMessageFormatting.LT_TEXT, this.getKey(), CommandMessageFormatting.ELLIPSIS_TEXT, CommandMessageFormatting.GT_TEXT);
        }
    }

    private static class EnumValueElement<T extends Enum<T>>
    extends PatternMatchingCommandElement {
        private final Class<T> type;
        private final Map<String, T> values;

        EnumValueElement(Text key, Class<T> type) {
            super(key);
            this.type = type;
            this.values = Arrays.stream(type.getEnumConstants()).collect(Collectors.toMap(value -> value.name().toLowerCase(), Function.identity(), (value, value2) -> {
                throw new UnsupportedOperationException(type.getCanonicalName() + " contains more than one enum constant with the same name, only differing by capitalization, which is unsupported.");
            }));
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return this.values.keySet();
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Enum value = (Enum)this.values.get(choice.toLowerCase());
            if (value == null) {
                throw new IllegalArgumentException("No enum constant " + this.type.getCanonicalName() + "." + choice);
            }
            return value;
        }
    }

    private static class NumericElement<T extends Number>
    extends KeyElement {
        private final Function<String, T> parseFunc;
        @Nullable
        private final BiFunction<String, Integer, T> parseRadixFunction;
        private final Function<String, Text> errorSupplier;

        protected NumericElement(Text key, Function<String, T> parseFunc, @Nullable BiFunction<String, Integer, T> parseRadixFunction, Function<String, Text> errorSupplier) {
            super(key);
            this.parseFunc = parseFunc;
            this.parseRadixFunction = parseRadixFunction;
            this.errorSupplier = errorSupplier;
        }

        @Override
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String input = args.next();
            try {
                if (this.parseRadixFunction != null) {
                    if (input.startsWith("0x")) {
                        return this.parseRadixFunction.apply(input.substring(2), 16);
                    }
                    if (input.startsWith("0b")) {
                        return this.parseRadixFunction.apply(input.substring(2), 2);
                    }
                }
                return this.parseFunc.apply(input);
            }
            catch (NumberFormatException ex) {
                throw args.createError(this.errorSupplier.apply(input));
            }
        }
    }

    private static class StringElement
    extends KeyElement {
        StringElement(Text key) {
            super(key);
        }

        @Override
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return args.next();
        }
    }

    private static abstract class KeyElement
    extends CommandElement {
        private KeyElement(Text key) {
            super(key);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return Collections.emptyList();
        }
    }

    private static class AllOfCommandElement
    extends CommandElement {
        private final CommandElement element;

        protected AllOfCommandElement(CommandElement element) {
            super(null);
            this.element = element;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            while (args.hasNext()) {
                this.element.parse(source, args, context);
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            while (args.hasNext()) {
                CommandArgs.Snapshot startState = args.getSnapshot();
                try {
                    this.element.parse(src, args, context);
                }
                catch (ArgumentParseException e) {
                    args.applySnapshot(startState);
                    return this.element.complete(src, args, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Text getUsage(CommandSource context) {
            return Text.of(this.element.getUsage(context), CommandMessageFormatting.STAR_TEXT);
        }
    }

    private static class RepeatedCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final int times;

        protected RepeatedCommandElement(CommandElement element, int times) {
            super(null);
            this.element = element;
            this.times = times;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            for (int i = 0; i < this.times; ++i) {
                this.element.parse(source, args, context);
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            for (int i = 0; i < this.times; ++i) {
                CommandArgs.Snapshot startState = args.getSnapshot();
                try {
                    this.element.parse(src, args, context);
                    continue;
                }
                catch (ArgumentParseException e) {
                    args.applySnapshot(startState);
                    return this.element.complete(src, args, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of(this.times, Character.valueOf('*'), this.element.getUsage(src));
        }
    }

    private static class OptionalCommandElement
    extends CommandElement {
        private final CommandElement element;
        @Nullable
        private final Object value;
        private final boolean considerInvalidFormatEmpty;

        OptionalCommandElement(CommandElement element, @Nullable Object value, boolean considerInvalidFormatEmpty) {
            super(null);
            this.element = element;
            this.value = value;
            this.considerInvalidFormatEmpty = considerInvalidFormatEmpty;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            if (!args.hasNext()) {
                Text key = this.element.getKey();
                if (key != null && this.value != null) {
                    context.putArg(key.toPlain(), this.value);
                }
                return;
            }
            CommandArgs.Snapshot startState = args.getSnapshot();
            try {
                this.element.parse(source, args, context);
            }
            catch (ArgumentParseException ex) {
                if (this.considerInvalidFormatEmpty || args.hasNext()) {
                    args.applySnapshot(startState);
                    if (this.element.getKey() != null && this.value != null) {
                        context.putArg(this.element.getUntranslatedKey(), this.value);
                    }
                }
                throw ex;
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return args.hasNext() ? null : this.element.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return this.element.complete(src, args, context);
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of("[", this.element.getUsage(src), "]");
        }
    }

    private static class FirstParsingCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        FirstParsingCommandElement(List<CommandElement> elements) {
            super(null);
            this.elements = elements;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            ArgumentParseException lastException = null;
            for (CommandElement element : this.elements) {
                CommandArgs.Snapshot startState = args.getSnapshot();
                CommandContext.Snapshot contextSnapshot = context.createSnapshot();
                try {
                    element.parse(source, args, context);
                    return;
                }
                catch (ArgumentParseException ex) {
                    lastException = ex;
                    args.applySnapshot(startState);
                    context.applySnapshot(contextSnapshot);
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.elements, input -> {
                if (input == null) {
                    return ImmutableList.of();
                }
                CommandArgs.Snapshot snapshot = args.getSnapshot();
                List<String> ret = input.complete(src, args, context);
                args.applySnapshot(snapshot);
                return ret;
            })));
        }

        @Override
        public Text getUsage(CommandSource commander) {
            Text.Builder ret = Text.builder();
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                ret.append(it.next().getUsage(commander));
                if (!it.hasNext()) continue;
                ret.append(CommandMessageFormatting.PIPE_TEXT);
            }
            return ret.build();
        }
    }

    private static class ChoicesCommandElement
    extends CommandElement {
        private static final int CUTOFF = 5;
        private final Supplier<Collection<String>> keySupplier;
        private final Function<String, ?> valueSupplier;
        private final Tristate choicesInUsage;

        ChoicesCommandElement(Text key, Supplier<Collection<String>> keySupplier, Function<String, ?> valueSupplier, Tristate choicesInUsage) {
            super(key);
            this.keySupplier = keySupplier;
            this.valueSupplier = valueSupplier;
            this.choicesInUsage = choicesInUsage;
        }

        @Override
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Object value = this.valueSupplier.apply(args.next());
            if (value == null) {
                throw args.createError(SpongeApiTranslationHelper.t("Argument was not a valid choice. Valid choices: %s", this.keySupplier.get().toString()));
            }
            return value;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            String prefix = args.nextIfPresent().orElse("");
            return (List)this.keySupplier.get().stream().filter(new StartsWithPredicate(prefix)).collect(ImmutableList.toImmutableList());
        }

        @Override
        public Text getUsage(CommandSource commander) {
            Collection<String> keys = this.keySupplier.get();
            if (this.choicesInUsage == Tristate.TRUE || this.choicesInUsage == Tristate.UNDEFINED && keys.size() <= 5) {
                Text.Builder build = Text.builder();
                build.append(CommandMessageFormatting.LT_TEXT);
                Iterator<String> it = keys.iterator();
                while (it.hasNext()) {
                    build.append(Text.of(it.next()));
                    if (!it.hasNext()) continue;
                    build.append(CommandMessageFormatting.PIPE_TEXT);
                }
                build.append(CommandMessageFormatting.GT_TEXT);
                return build.build();
            }
            return super.getUsage(commander);
        }
    }

    private static class SequenceCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        SequenceCommandElement(List<CommandElement> elements) {
            super(null);
            this.elements = elements;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            for (CommandElement element : this.elements) {
                element.parse(source, args, context);
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            HashSet completions = Sets.newHashSet();
            for (CommandElement element : this.elements) {
                CommandArgs.Snapshot state = args.getSnapshot();
                try {
                    element.parse(src, args, context);
                    if (state.equals(args.getSnapshot())) {
                        completions.addAll(element.complete(src, args, context));
                        args.applySnapshot(state);
                        continue;
                    }
                    if (args.hasNext()) {
                        completions.clear();
                        continue;
                    }
                    args.applySnapshot(state);
                    completions.addAll(element.complete(src, args, context));
                    if (!(element instanceof OptionalCommandElement)) break;
                    args.applySnapshot(state);
                }
                catch (ArgumentParseException ignored) {
                    args.applySnapshot(state);
                    completions.addAll(element.complete(src, args, context));
                    break;
                }
            }
            return Lists.newArrayList((Iterable)completions);
        }

        @Override
        public Text getUsage(CommandSource commander) {
            Text.Builder build = Text.builder();
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                Text usage = it.next().getUsage(commander);
                if (usage.isEmpty()) continue;
                build.append(usage);
                if (!it.hasNext()) continue;
                build.append(CommandMessageFormatting.SPACE_TEXT);
            }
            return build.build();
        }
    }

    static class MarkTrueCommandElement
    extends CommandElement {
        MarkTrueCommandElement(Text key) {
            super(key);
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return true;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return Collections.emptyList();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.EMPTY;
        }
    }

    private static class PluginCommandElement
    extends PatternMatchingCommandElement {
        protected PluginCommandElement(@Nullable Text key) {
            super(key);
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getPluginManager().getPlugins().stream().map(PluginContainer::getId).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<PluginContainer> plugin = Sponge.getPluginManager().getPlugin(choice);
            return plugin.orElseThrow(() -> new IllegalArgumentException("Plugin " + choice + " was not found"));
        }
    }
}

