/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.advancement.ITrigger;
import org.spongepowered.common.advancement.SpongeFilteredTrigger;
import org.spongepowered.common.interfaces.advancement.IMixinICriterionTriggerListener;

public class SpongeTrigger
implements ICriterionTrigger<SpongeFilteredTrigger>,
ITrigger {
    private final Class<FilteredTriggerConfiguration> triggerConfigurationClass;
    final Function<JsonObject, FilteredTriggerConfiguration> constructor;
    private final ResourceLocation id;
    private final Multimap<PlayerAdvancements, ICriterionTrigger.Listener> listeners = HashMultimap.create();
    @Nullable
    final Consumer<CriterionEvent.Trigger> eventHandler;
    private final String name;

    SpongeTrigger(Class<FilteredTriggerConfiguration> triggerConfigurationClass, Function<JsonObject, FilteredTriggerConfiguration> constructor, ResourceLocation id, @Nullable Consumer<CriterionEvent.Trigger> eventHandler, String name) {
        this.triggerConfigurationClass = triggerConfigurationClass;
        this.eventHandler = eventHandler;
        this.constructor = constructor;
        this.id = id;
        this.name = name;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener listener) {
        this.listeners.put((Object)playerAdvancementsIn, (Object)listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener listener) {
        this.listeners.remove((Object)playerAdvancementsIn, (Object)listener);
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.removeAll((Object)playerAdvancementsIn);
    }

    public SpongeFilteredTrigger deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new SpongeFilteredTrigger(this, this.constructor.apply(json));
    }

    @Override
    public Class<FilteredTriggerConfiguration> getConfigurationType() {
        return this.triggerConfigurationClass;
    }

    @Override
    public void trigger(Player player) {
        PlayerAdvancements playerAdvancements = ((EntityPlayerMP)player).func_192039_O();
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        TypeToken typeToken = TypeToken.of(this.triggerConfigurationClass);
        for (ICriterionTrigger.Listener listener : new ArrayList(this.listeners.get((Object)playerAdvancements))) {
            IMixinICriterionTriggerListener mixinListener = (IMixinICriterionTriggerListener)listener;
            Advancement advancement = (Advancement)mixinListener.getAdvancement();
            AdvancementCriterion advancementCriterion = (AdvancementCriterion)((net.minecraft.advancements.Advancement)advancement).func_192073_f().get(mixinListener.getCriterionName());
            CriterionEvent.Trigger event = SpongeEventFactory.createCriterionEventTrigger(cause, advancement, advancementCriterion, typeToken, player, (FilteredTrigger)listener.func_192158_a(), this.eventHandler == null);
            if (this.eventHandler != null) {
                this.eventHandler.accept(event);
                if (!event.getResult()) continue;
            }
            SpongeImpl.postEvent(event);
            if (!event.getResult()) continue;
            listener.func_192159_a(playerAdvancements);
        }
    }

    @Nullable
    public Consumer<CriterionEvent.Trigger> getEventHandler() {
        return this.eventHandler;
    }
}

