/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.plugin.PluginContainer;

@ConfigSerializable
public class MetricsCategory {
    @Setting(value="default-permission", comment="Determines whether plugins that are newly added are allowed to perform\ndata/metric collection by default. Plugins detected by Sponge will be added to the \"plugin-permissions\" section with this value.\n\nSet to true to enable metric gathering by default, false otherwise.")
    private boolean defaultPermission = false;
    @Setting(value="plugin-permissions", comment="Provides (or revokes) permission for metric gathering on a per plugin basis.\nEntries should be in the format \"plugin-id=<true|false>\".\n\nDeleting an entry from this list will reset it to the default specified in\n\"default-permission\"")
    private Map<String, Boolean> perPluginPermissions = new HashMap<String, Boolean>();

    public boolean isGloballyEnabled() {
        return this.defaultPermission;
    }

    public Optional<Boolean> getPluginPermission(PluginContainer container) {
        return Optional.ofNullable(this.perPluginPermissions.get(container.getId()));
    }

    public Map<String, Boolean> getPluginPermissions() {
        return new HashMap<String, Boolean>(this.perPluginPermissions);
    }
}

