/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.item;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;

public class SpongeItemStackSnapshotBuilder
extends AbstractDataBuilder<ItemStackSnapshot>
implements DataBuilder<ItemStackSnapshot> {
    public SpongeItemStackSnapshotBuilder() {
        super(ItemStackSnapshot.class, 2);
    }

    @Override
    protected Optional<ItemStackSnapshot> buildContent(DataView container) throws InvalidDataException {
        if (container.contains(DataQueries.ITEM_TYPE, DataQueries.ITEM_COUNT)) {
            String itemString = DataUtil.getData(container, DataQueries.ITEM_TYPE, String.class);
            ItemType itemType = SpongeImpl.getRegistry().getType(ItemType.class, itemString).get();
            int count = DataUtil.getData(container, DataQueries.ITEM_COUNT, Integer.class);
            int damage = container.getInt(DataQueries.ITEM_DAMAGE_VALUE).orElse(0);
            ImmutableList<ImmutableDataManipulator<?, ?>> manipulators = container.contains(DataQueries.DATA_MANIPULATORS) ? DataUtil.deserializeImmutableManipulatorList(container.getViewList(DataQueries.DATA_MANIPULATORS).get()) : ImmutableList.of();
            NBTTagCompound compound = container.contains(DataQueries.UNSAFE_NBT) ? NbtTranslator.getInstance().translateData(container.getView(DataQueries.UNSAFE_NBT).get()) : null;
            return Optional.of(new SpongeItemStackSnapshot(itemType, count, damage, manipulators, compound));
        }
        return Optional.empty();
    }
}

