/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.util.DataUtil;

public abstract class AbstractImmutableData<I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
implements ImmutableDataManipulator<I, M> {
    private final Class<I> immutableClass;
    private final Map<Key<?>, Supplier<ImmutableValue<?>>> keyValueMap = Maps.newHashMap();
    private final Map<Key<?>, Supplier<?>> keyFieldGetterMap = Maps.newHashMap();

    protected AbstractImmutableData(Class<I> immutableClass) {
        this.immutableClass = (Class)Preconditions.checkNotNull(immutableClass);
    }

    protected final void registerKeyValue(Key<?> key, Supplier<ImmutableValue<?>> function) {
        this.keyValueMap.put((Key<?>)Preconditions.checkNotNull(key), (Supplier<ImmutableValue<?>>)Preconditions.checkNotNull(function));
    }

    protected final void registerFieldGetter(Key<?> key, Supplier<?> function) {
        this.keyFieldGetterMap.put((Key<?>)Preconditions.checkNotNull(key), (Supplier<?>)Preconditions.checkNotNull(function));
    }

    protected abstract void registerGetters();

    @Override
    public <E> Optional<I> with(Key<? extends BaseValue<E>> key, E value) {
        Optional processor = DataUtil.getImmutableProcessor(this.immutableClass);
        Preconditions.checkArgument((boolean)processor.isPresent(), (Object)("Invalid Key for " + this.immutableClass.getCanonicalName() + ". Use supports(Key) to avoid exceptions!"));
        return processor.get().with((Key)Preconditions.checkNotNull(key), Preconditions.checkNotNull(value), this);
    }

    @Override
    public final I copy() {
        return (I)this;
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        if (!this.supports(key)) {
            return Optional.empty();
        }
        return Optional.of(this.keyFieldGetterMap.get(key).get());
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        if (!this.keyValueMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of((BaseValue)Preconditions.checkNotNull(this.keyValueMap.get(key).get()));
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.keyFieldGetterMap.containsKey(Preconditions.checkNotNull(key));
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.copyOf(this.keyValueMap.keySet());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Supplier<ImmutableValue<?>> function : this.keyValueMap.values()) {
            builder.add(Preconditions.checkNotNull(function.get()));
        }
        return builder.build();
    }

    public int hashCode() {
        ArrayList objects = Lists.newArrayList();
        objects.addAll(this.keyFieldGetterMap.values().stream().map(Supplier::get).collect(Collectors.toList()));
        return Objects.hashCode((Object[])new Object[]{this.immutableClass, objects});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractImmutableData other = (AbstractImmutableData)obj;
        return Objects.equal(this.immutableClass, other.immutableClass);
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion());
    }
}

