/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import java.util.Optional;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.mutable.block.DirectionalData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeDirectionalData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SkullRotationDataProcessor
extends AbstractTileEntitySingleDataProcessor<TileEntitySkull, Direction, Value<Direction>, DirectionalData, ImmutableDirectionalData> {
    public SkullRotationDataProcessor() {
        super(TileEntitySkull.class, Keys.DIRECTION);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected Value<Direction> constructValue(Direction actualValue) {
        return new SpongeValue<Direction>(Keys.DIRECTION, Direction.NONE, actualValue);
    }

    @Override
    protected boolean set(TileEntitySkull skull, Direction value) {
        if (value.ordinal() > 15) {
            return false;
        }
        skull.func_145903_a(value.ordinal());
        return true;
    }

    @Override
    protected Optional<Direction> getVal(TileEntitySkull skull) {
        if (skull.func_145831_w().func_180495_p(skull.func_174877_v()).func_177229_b((IProperty)BlockSkull.field_176418_a) != EnumFacing.UP) {
            return Optional.empty();
        }
        int rot = skull.field_145910_i % 16;
        return Optional.of(Direction.values()[rot < 0 ? rot + 16 : rot]);
    }

    @Override
    protected ImmutableValue<Direction> constructImmutableValue(Direction value) {
        return ImmutableDataCachingUtil.getValue(ImmutableSpongeValue.class, Keys.DIRECTION, Direction.NORTH, value, new Object[0]);
    }

    @Override
    protected DirectionalData createManipulator() {
        return new SpongeDirectionalData();
    }
}

