/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableSignData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeSignData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.text.SpongeTexts;

public class TileEntitySignDataProcessor
extends AbstractTileEntitySingleDataProcessor<TileEntitySign, List<Text>, ListValue<Text>, SignData, ImmutableSignData> {
    public TileEntitySignDataProcessor() {
        super(TileEntitySign.class, Keys.SIGN_LINES);
    }

    @Override
    protected Optional<List<Text>> getVal(TileEntitySign sign) {
        ITextComponent[] rawLines = sign.field_145915_a;
        ArrayList signLines = Lists.newArrayListWithExpectedSize((int)4);
        for (int i = 0; i < rawLines.length; ++i) {
            signLines.add(i, rawLines[i] == null ? Text.EMPTY : SpongeTexts.toText(rawLines[i]));
        }
        return Optional.of(signLines);
    }

    @Override
    protected boolean set(TileEntitySign sign, List<Text> lines) {
        for (int i = 0; i < sign.field_145915_a.length; ++i) {
            Text line;
            Text text = line = lines.size() > i ? lines.get(i) : Text.EMPTY;
            if (line == null) {
                throw new IllegalArgumentException("A null line was given at index " + i);
            }
            sign.field_145915_a[i] = SpongeTexts.toComponent(line);
        }
        sign.func_70296_d();
        ((WorldServer)sign.func_145831_w()).func_184164_w().func_180244_a(sign.func_174877_v());
        return true;
    }

    @Override
    public Optional<SignData> fill(DataContainer container, SignData signData) {
        if (!container.contains(Keys.SIGN_LINES.getQuery())) {
            return Optional.empty();
        }
        Preconditions.checkNotNull((Object)signData);
        List<String> lines = container.getStringList(Keys.SIGN_LINES.getQuery()).get();
        ArrayList textLines = Lists.newArrayListWithCapacity((int)4);
        try {
            for (int i = 0; i < 4; ++i) {
                textLines.set(i, TextSerializers.JSON.deserialize(lines.get(i)));
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not translate text json lines", e);
        }
        return Optional.of(signData.set(Keys.SIGN_LINES, textLines));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public ListValue<Text> constructValue(List<Text> defaultValue) {
        return new SpongeListValue<Text>(Keys.SIGN_LINES, defaultValue);
    }

    @Override
    protected ImmutableValue<List<Text>> constructImmutableValue(List<Text> value) {
        return new ImmutableSpongeListValue<Text>(Keys.SIGN_LINES, ImmutableList.copyOf(value));
    }

    @Override
    protected SignData createManipulator() {
        return new SpongeSignData();
    }
}

