/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;

public class ExperienceSinceLevelValueProcessor
extends AbstractSpongeValueProcessor<EntityPlayer, Integer, MutableBoundedValue<Integer>> {
    public ExperienceSinceLevelValueProcessor() {
        super(EntityPlayer.class, Keys.EXPERIENCE_SINCE_LEVEL);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_SINCE_LEVEL).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(EntityPlayer container, Integer value) {
        while (value >= container.func_71050_bK()) {
            value = value - container.func_71050_bK();
        }
        ((IMixinEntityPlayer)container).setExperienceSinceLevel(value);
        ((IMixinEntityPlayerMP)container).refreshExp();
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityPlayer container) {
        return Optional.of(((IMixinEntityPlayer)container).getExperienceSinceLevel());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }
}

