/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.item;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.text.SpongeTexts;

public class ItemDisplayNameValueProcessor
extends AbstractSpongeValueProcessor<ItemStack, Text, Value<Text>> {
    public ItemDisplayNameValueProcessor() {
        super(ItemStack.class, Keys.DISPLAY_NAME);
    }

    @Override
    protected Value<Text> constructValue(Text defaultValue) {
        return new SpongeValue<Text>(Keys.DISPLAY_NAME, Text.of(), defaultValue);
    }

    @Override
    protected boolean set(ItemStack container, Text value) {
        String legacy = SpongeTexts.toLegacy(value);
        if (container.func_77973_b() == Items.field_151164_bB) {
            NbtDataUtil.getOrCreateCompound(container).func_74778_a("title", legacy);
        } else {
            container.func_151001_c(legacy);
        }
        return true;
    }

    @Override
    protected Optional<Text> getVal(ItemStack container) {
        if (container.func_77973_b() == Items.field_151164_bB) {
            NBTTagCompound mainCompound = container.func_77978_p();
            if (mainCompound == null) {
                return Optional.empty();
            }
            String titleString = mainCompound.func_74779_i("title");
            return Optional.of(SpongeTexts.fromLegacy(titleString));
        }
        NBTTagCompound mainCompound = container.func_179543_a("display");
        if (mainCompound != null && mainCompound.func_150297_b("Name", 8)) {
            String displayString = mainCompound.func_74779_i("Name");
            return Optional.of(SpongeTexts.fromLegacy(displayString));
        }
        return Optional.empty();
    }

    @Override
    protected ImmutableValue<Text> constructImmutableValue(Text value) {
        return new ImmutableSpongeValue<Text>(Keys.DISPLAY_NAME, Text.of(), value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof ItemStack) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional optional = this.getValueFromContainer(container);
            if (optional.isPresent()) {
                try {
                    ((ItemStack)container).func_135074_t();
                    return builder.replace(new ImmutableSpongeValue<Text>((Key<BaseValue<Text>>)Keys.DISPLAY_NAME, (Text)optional.get())).result(DataTransactionResult.Type.SUCCESS).build();
                }
                catch (Exception e) {
                    SpongeImpl.getLogger().error("There was an issue removing the displayname from an itemstack!", (Throwable)e);
                    return builder.result(DataTransactionResult.Type.ERROR).build();
                }
            }
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }
}

