/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.TypeTokens;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeManipulatorRegistry;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.fixer.entity.EntityTrackedUser;
import org.spongepowered.common.data.fixer.entity.player.PlayerRespawnData;
import org.spongepowered.common.data.fixer.world.SpongeLevelFixer;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.value.NbtValueProcessor;
import org.spongepowered.common.data.persistence.SerializedDataTransaction;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.util.DataProcessorDelegate;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.ValueProcessorDelegate;
import org.spongepowered.common.util.TypeTokenHelper;

public final class DataUtil {
    public static final int DATA_VERSION = 1;
    public static final DataFixer spongeDataFixer = new DataFixer(1);
    private static final Supplier<InvalidDataException> INVALID_DATA_EXCEPTION_SUPPLIER = InvalidDataException::new;

    public static DataView checkDataExists(DataView dataView, DataQuery query) throws InvalidDataException {
        if (!((DataView)Preconditions.checkNotNull((Object)dataView)).contains((DataQuery)Preconditions.checkNotNull((Object)query))) {
            throw new InvalidDataException("Missing data for query: " + query.asString('.'));
        }
        return dataView;
    }

    public static <T> T getData(DataView dataView, Key<? extends BaseValue<T>> key) throws InvalidDataException {
        Object object;
        DataUtil.checkDataExists(dataView, ((Key)Preconditions.checkNotNull(key)).getQuery());
        TypeToken<?> elementToken = key.getElementToken();
        if (elementToken.isSubtypeOf(TypeToken.of(DataSerializable.class))) {
            object = dataView.getSerializable(key.getQuery(), elementToken.getRawType()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
        } else if (elementToken.isSubtypeOf(TypeToken.of(CatalogType.class))) {
            object = dataView.getCatalogType(key.getQuery(), elementToken.getRawType()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
        } else if (elementToken.isSubtypeOf(TypeToken.of(Text.class))) {
            String input = dataView.getString(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
            object = TextSerializers.PLAIN.deserialize(input);
        } else if (elementToken.isSubtypeOf(TypeToken.of(List.class))) {
            Optional<List<?>> opt;
            if (elementToken.isSubtypeOf(TypeTokens.LIST_DATA_SERIALIZEABLE_TOKEN)) {
                Class<?> listElement = TypeTokenHelper.getGenericParam(elementToken, 0);
                opt = dataView.getSerializableList(key.getQuery(), listElement);
            } else {
                opt = dataView.getList(key.getQuery());
            }
            object = opt.orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
        } else if (elementToken.isSubtypeOf(TypeToken.of(Set.class))) {
            HashSet set = new HashSet();
            set.addAll(dataView.getList(key.getQuery()).orElse(Collections.emptyList()));
            object = set;
        } else {
            Optional<DataTranslator<DataTranslator>> translator;
            object = elementToken.isSubtypeOf(TypeToken.of(Map.class)) ? dataView.getMap(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId())) : (elementToken.isSubtypeOf(TypeToken.of(Enum.class)) ? Enum.valueOf(elementToken.getRawType(), dataView.getString(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()))) : ((translator = SpongeDataManager.getInstance().getTranslator(elementToken.getRawType())).isPresent() ? translator.map(trans -> trans.translate(dataView.getView(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId())))).orElseThrow(() -> new InvalidDataException("Could not translate translateable: " + key.getId())) : dataView.get(key.getQuery()).orElseThrow(() -> new InvalidDataException("Could not translate translateable: " + key.getId()))));
        }
        return object;
    }

    public static <T> T getData(DataView dataView, Key<?> key, Class<T> clazz) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, ((Key)Preconditions.checkNotNull(key)).getQuery());
        Object object = dataView.get(key.getQuery()).get();
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        throw new InvalidDataException("Could not cast to the correct class type!");
    }

    public static <T> T getData(DataView dataView, DataQuery query, Class<T> data) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, query);
        Object object = dataView.get(query).get();
        if (data.isInstance(object)) {
            return (T)object;
        }
        throw new InvalidDataException("Data does not match!");
    }

    public static List<DataView> getSerializedManipulatorList(Iterable<DataManipulator<?, ?>> manipulators) {
        return DataUtil.getSerializedManipulatorList(manipulators, DataUtil::getRegistrationFor);
    }

    public static List<DataView> getSerializedImmutableManipulatorList(Iterable<ImmutableDataManipulator<?, ?>> manipulators) {
        return DataUtil.getSerializedManipulatorList(manipulators, DataUtil::getRegistrationFor);
    }

    private static <T extends DataSerializable> List<DataView> getSerializedManipulatorList(Iterable<T> manipulators, Function<T, DataRegistration> func) {
        Preconditions.checkNotNull(manipulators);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataSerializable manipulator : manipulators) {
            DataContainer container = DataContainer.createNew();
            container.set(Queries.CONTENT_VERSION, (Object)2);
            container.set(DataQueries.DATA_ID, (Object)func.apply(manipulator).getId()).set(DataQueries.INTERNAL_DATA, (Object)manipulator.toContainer());
            builder.add((Object)container);
        }
        return builder.build();
    }

    public static SerializedDataTransaction deserializeManipulatorList(List<DataView> containers) {
        Preconditions.checkNotNull(containers);
        SerializedDataTransaction.Builder builder = SerializedDataTransaction.builder();
        for (DataView view : containers) {
            DataView updated = DataUtil.updateDataViewForDataManipulator(view);
            DataUtil.findDataId(builder, updated).ifPresent(dataId -> DataUtil.tryDeserializeManipulator(builder, updated, dataId));
        }
        return builder.build();
    }

    private static Optional<String> findDataId(SerializedDataTransaction.Builder builder, DataView view) {
        Optional<String> dataId = view.getString(DataQueries.DATA_ID);
        if (!dataId.isPresent()) {
            String dataClass = view.getString(DataQueries.DATA_CLASS).orElseThrow(DataUtil.dataNotFound());
            DataUtil.addFailedDeserialization(builder, view, dataClass, null);
        }
        return dataId;
    }

    private static void tryDeserializeManipulator(SerializedDataTransaction.Builder builder, DataView view, String dataId) {
        DataView manipulatorView = view.getView(DataQueries.INTERNAL_DATA).orElseThrow(DataUtil.dataNotFound());
        try {
            Optional build = DataUtil.deserializeManipulator(dataId, manipulatorView);
            if (build.isPresent()) {
                builder.successfulData((DataManipulator)build.get());
            } else {
                DataUtil.addFailedDeserialization(builder, view, dataId, null);
            }
        }
        catch (Exception e) {
            DataUtil.addFailedDeserialization(builder, view, dataId, e);
        }
    }

    private static <T extends DataManipulator<?, ?>> Optional<T> deserializeManipulator(String dataId, DataView data) {
        return DataUtil.getRegistrationFor(dataId).map(DataRegistration::getDataManipulatorBuilder).flatMap(b -> b.build(data));
    }

    private static void addFailedDeserialization(SerializedDataTransaction.Builder builder, DataView view, String dataId, @Nullable Throwable cause) {
        SpongeImpl.getDataConfig().getConfig().getDataRegistrationConfig().addFailedData(dataId, cause);
        SpongeImpl.getDataConfig().getConfig().getDataRegistrationConfig().purgeOrAllow(builder, dataId, view);
        try {
            SpongeImpl.getDataConfig().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DataView updateDataViewForDataManipulator(DataView dataView) {
        int version = dataView.getInt(Queries.CONTENT_VERSION).orElse(1);
        if (version != 2) {
            DataContentUpdater contentUpdater = SpongeDataManager.getInstance().getWrappedContentUpdater(DataManipulator.class, version, 2).orElseThrow(() -> new IllegalArgumentException("Could not find a content updater for DataManipulator information with version: " + version));
            return contentUpdater.update(dataView);
        }
        return dataView;
    }

    public static ImmutableList<ImmutableDataManipulator<?, ?>> deserializeImmutableManipulatorList(List<DataView> containers) {
        Preconditions.checkNotNull(containers);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataView view : containers) {
            view = DataUtil.updateDataViewForDataManipulator(view);
            String dataId = view.getString(DataQueries.DATA_ID).orElseThrow(DataUtil.dataNotFound());
            DataView manipulatorView = view.getView(DataQueries.INTERNAL_DATA).orElseThrow(DataUtil.dataNotFound());
            try {
                DataUtil.deserializeManipulator(dataId, manipulatorView).map(DataManipulator::asImmutable).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (Exception e) {
                new InvalidDataException("Could not translate " + dataId + "!", e).printStackTrace();
            }
        }
        return builder.build();
    }

    public static Location<World> getLocation(DataView view, boolean castToInt) {
        UUID worldUuid = UUID.fromString(view.getString(Queries.WORLD_ID).get());
        double x = view.getDouble(Queries.POSITION_X).get();
        double y = view.getDouble(Queries.POSITION_Y).get();
        double z = view.getDouble(Queries.POSITION_Z).get();
        if (castToInt) {
            return new Location<Extent>((Extent)SpongeImpl.getGame().getServer().getWorld(worldUuid).get(), (int)x, (int)y, (int)z);
        }
        return new Location<Extent>((Extent)SpongeImpl.getGame().getServer().getWorld(worldUuid).get(), x, y, z);
    }

    public static Vector3i getPosition3i(DataView view) {
        return DataUtil.getPosition3i(view, DataQueries.SNAPSHOT_WORLD_POSITION);
    }

    public static Vector3i getPosition3i(DataView view, DataQuery query) {
        DataUtil.checkDataExists(view, DataQueries.SNAPSHOT_WORLD_POSITION);
        DataView internal = view.getView(DataQueries.SNAPSHOT_WORLD_POSITION).get();
        int x = internal.getInt(Queries.POSITION_X).get();
        int y = internal.getInt(Queries.POSITION_Y).get();
        int z = internal.getInt(Queries.POSITION_Z).get();
        return new Vector3i(x, y, z);
    }

    public static Vector3d getPosition3d(DataView view) {
        return DataUtil.getPosition3d(view, DataQueries.SNAPSHOT_WORLD_POSITION);
    }

    public static Vector3d getPosition3d(DataView view, DataQuery query) {
        DataUtil.checkDataExists(view, query);
        DataView internal = view.getView(query).get();
        double x = internal.getDouble(Queries.POSITION_X).get();
        double y = internal.getDouble(Queries.POSITION_Y).get();
        double z = internal.getDouble(Queries.POSITION_Z).get();
        return new Vector3d(x, y, z);
    }

    public static Supplier<InvalidDataException> dataNotFound() {
        return INVALID_DATA_EXCEPTION_SUPPLIER;
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void registerDataProcessorAndImpl(Class<T> manipulatorClass, Class<? extends T> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, DataProcessor<T, I> processor) {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Registrations are no longer allowed!");
        Preconditions.checkArgument((!Modifier.isAbstract(implClass.getModifiers()) ? 1 : 0) != 0, (Object)"The Implemented DataManipulator class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(implClass.getModifiers()) ? 1 : 0) != 0, (Object)"The Implemented DataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!Modifier.isAbstract(implImClass.getModifiers()) ? 1 : 0) != 0, (Object)"The implemented ImmutableDataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!Modifier.isInterface(implImClass.getModifiers()) ? 1 : 0) != 0, (Object)"The implemented ImmutableDataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!(processor instanceof DataProcessorDelegate) ? 1 : 0) != 0, (Object)"Cannot register DataProcessorDelegates!");
        SpongeManipulatorRegistry.getInstance().register(manipulatorClass, implClass, immutableDataManipulator, implImClass, processor);
    }

    public static <E, V extends BaseValue<E>, T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void registerDualProcessor(Class<T> manipulatorClass, Class<? extends T> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, AbstractSingleDataSingleTargetProcessor<?, E, V, T, I> processor) {
        DataUtil.registerDataProcessorAndImpl(manipulatorClass, implClass, immutableDataManipulator, implImClass, processor);
        DataUtil.registerValueProcessor(processor.getKey(), processor);
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataProcessor<T, I>> getProcessor(Class<T> mutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(mutableClass));
    }

    public static Optional<DataProcessor<?, ?>> getWildProcessor(Class<? extends DataManipulator<?, ?>> mutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(mutableClass));
    }

    public static Optional<DataProcessor> getWildDataProcessor(Class<? extends DataManipulator> mutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(mutableClass));
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataProcessor<T, I>> getImmutableProcessor(Class<I> immutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(immutableClass));
    }

    public static Optional<DataProcessor> getWildImmutableProcessor(Class<? extends ImmutableDataManipulator<?, ?>> immutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(immutableClass));
    }

    public static <E, V extends BaseValue<E>> void registerValueProcessor(Key<V> key, ValueProcessor<E, V> valueProcessor) {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Registrations are no longer allowed!");
        Preconditions.checkNotNull(valueProcessor);
        Preconditions.checkArgument((!(valueProcessor instanceof ValueProcessorDelegate) ? 1 : 0) != 0, (Object)"Cannot register ValueProcessorDelegates! READ THE DOCS!");
        Preconditions.checkNotNull(key);
        SpongeManipulatorRegistry.getInstance().registerValueProcessor(key, valueProcessor);
    }

    public static <E, V extends BaseValue<E>> Optional<ValueProcessor<E, V>> getValueProcessor(Key<V> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(key));
    }

    public static Optional<ValueProcessor<?, ?>> getWildValueProcessor(Key<?> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(key));
    }

    public static <E> Optional<ValueProcessor<E, ? extends BaseValue<E>>> getBaseValueProcessor(Key<? extends BaseValue<E>> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(key));
    }

    public static RawDataValidator getValidators(ValidationType validationType) {
        return new DelegateDataValidator((ImmutableList<RawDataValidator>)ImmutableList.of(), validationType);
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<NbtDataProcessor<T, I>> getNbtProcessor(NbtDataType dataType, Class<T> clazz) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtDelegate(dataType, clazz));
    }

    public static <E, V extends BaseValue<E>> Optional<NbtValueProcessor<E, V>> getNbtProcessor(NbtDataType dataType, Key<V> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtProcessor(dataType, key));
    }

    public static Optional<NbtDataProcessor> getRawNbtProcessor(NbtDataType dataType, Class<? extends DataManipulator> aClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtDelegate(dataType, aClass));
    }

    public static Optional<NbtValueProcessor> getRawNbtProcessor(NbtDataType dataType, Key<?> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtProcessor(dataType, key));
    }

    public static Collection<NbtDataProcessor<?, ?>> getNbtProcessors(NbtDataType type) {
        return SpongeManipulatorRegistry.getInstance().getNbtProcessors(type);
    }

    public static Collection<NbtValueProcessor<?, ?>> getNbtValueProcessors(NbtDataType type) {
        return SpongeManipulatorRegistry.getInstance().getNbtValueProcessors(type);
    }

    public static DataRegistration<?, ?> getRegistrationFor(DataManipulator<?, ?> manipulator) {
        return SpongeManipulatorRegistry.getInstance().getRegistrationFor(manipulator);
    }

    public static DataRegistration<?, ?> getRegistrationFor(ImmutableDataManipulator<?, ?> immutableDataManipulator) {
        return SpongeManipulatorRegistry.getInstance().getRegistrationFor(immutableDataManipulator);
    }

    public static Optional<DataRegistration<?, ?>> getRegistrationFor(String id) {
        return SpongeManipulatorRegistry.getInstance().getRegistrationFor(id);
    }

    static {
        spongeDataFixer.func_188256_a((IFixType)FixTypes.LEVEL, (IFixableData)new SpongeLevelFixer());
        spongeDataFixer.func_188256_a((IFixType)FixTypes.ENTITY, (IFixableData)new EntityTrackedUser());
        spongeDataFixer.func_188256_a((IFixType)FixTypes.PLAYER, (IFixableData)new PlayerRespawnData());
    }
}

