/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.google.common.base.Preconditions;
import net.minecraft.block.BlockLever;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.Direction;

public class DirectionResolver {
    public static EnumFacing getFor(Direction direction) {
        switch ((Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)))) {
            case UP: {
                return EnumFacing.UP;
            }
            case DOWN: {
                return EnumFacing.DOWN;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case NORTH: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalArgumentException("No matching direction found for direction: " + (Object)((Object)direction));
    }

    public static Direction getFor(EnumFacing facing) {
        switch ((EnumFacing)Preconditions.checkNotNull((Object)facing)) {
            case UP: {
                return Direction.UP;
            }
            case DOWN: {
                return Direction.DOWN;
            }
            case WEST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case NORTH: {
                return Direction.NORTH;
            }
        }
        throw new IllegalArgumentException("No matching enum facing direction found for direction: " + facing);
    }

    public static Direction getFor(BlockLever.EnumOrientation orientation) {
        switch (orientation) {
            case DOWN_X: {
                return Direction.DOWN;
            }
            case EAST: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case NORTH: {
                return Direction.NORTH;
            }
            case UP_Z: {
                return Direction.UP;
            }
            case UP_X: {
                return Direction.UP;
            }
            case DOWN_Z: {
                return Direction.DOWN;
            }
        }
        return Direction.NORTH;
    }

    public static BlockLever.EnumOrientation getAsOrientation(Direction direction, Axis axis) {
        switch (direction) {
            case DOWN: {
                return axis == Axis.Z ? BlockLever.EnumOrientation.DOWN_Z : BlockLever.EnumOrientation.DOWN_X;
            }
            case EAST: {
                return BlockLever.EnumOrientation.EAST;
            }
            case WEST: {
                return BlockLever.EnumOrientation.WEST;
            }
            case SOUTH: {
                return BlockLever.EnumOrientation.SOUTH;
            }
            case NORTH: {
                return BlockLever.EnumOrientation.NORTH;
            }
            case UP: {
                return axis == Axis.Z ? BlockLever.EnumOrientation.UP_Z : BlockLever.EnumOrientation.UP_X;
            }
        }
        return BlockLever.EnumOrientation.NORTH;
    }
}

