/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.NbtDataTypes;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.Validations;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, org.spongepowered.api.entity.Entity>
implements EntityArchetype {
    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        super(builder.entityType, NbtTranslator.getInstance().translateData(builder.entityData));
    }

    @Override
    public EntityType getType() {
        return (EntityType)this.type;
    }

    @Override
    public DataContainer getEntityData() {
        return NbtTranslator.getInstance().translateFrom(this.data);
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> apply(Location<org.spongepowered.api.world.World> location) {
        Vector3d position = location.getPosition();
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        BlockPos blockPos = new BlockPos(x, y, z);
        org.spongepowered.api.world.World world = location.getExtent();
        WorldServer worldServer = (WorldServer)world;
        Entity entity = null;
        try {
            Class<? extends org.spongepowered.api.entity.Entity> oclass = ((EntityType)this.type).getEntityClass();
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            return Optional.empty();
        }
        this.data.func_74782_a("Pos", (NBTBase)NbtDataUtil.newDoubleNBTList(x, y, z));
        this.data.func_74768_a("Dimension", ((IMixinWorldInfo)((Object)location.getExtent().getProperties())).getDimensionId().intValue());
        entity.func_70020_e(this.data);
        this.data.func_82580_o("Pos");
        this.data.func_82580_o("Dimension");
        org.spongepowered.api.entity.Entity spongeEntity = EntityUtil.fromNative(entity);
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
        entities.add(spongeEntity);
        SpawnType require = Sponge.getCauseStackManager().getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
        if (!event.isCancelled()) {
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldServer;
            entity.func_70080_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
            if (entity instanceof EntityLiving) {
                mixinWorldServer.forceSpawnEntity(EntityUtil.fromNative(entity));
                ((EntityLiving)entity).func_180482_a(worldServer.func_175649_E(blockPos), null);
                ((EntityLiving)entity).func_70656_aK();
            } else {
                mixinWorldServer.forceSpawnEntity(EntityUtil.fromNative(entity));
            }
            return Optional.of(spongeEntity);
        }
        return Optional.empty();
    }

    @Override
    public EntitySnapshot toSnapshot(Location<org.spongepowered.api.world.World> location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        NBTTagCompound newCompound = this.data.func_74737_b();
        newCompound.func_74782_a("Pos", (NBTBase)NbtDataUtil.newDoubleNBTList(location.getPosition().getX(), location.getPosition().getY(), location.getPosition().getZ()));
        newCompound.func_74768_a("Dimension", ((IMixinWorldInfo)((Object)location.getExtent().getProperties())).getDimensionId().intValue());
        builder.compound = newCompound;
        builder.worldId = location.getExtent().getUniqueId();
        builder.position = location.getPosition();
        return builder.build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(DataQueries.EntityArchetype.ENTITY_TYPE, (Object)this.type).set(DataQueries.EntityArchetype.ENTITY_DATA, (Object)this.getEntityData());
    }

    @Override
    protected NbtDataType getDataType() {
        return NbtDataTypes.ENTITY;
    }

    @Override
    protected ValidationType getValidationType() {
        return Validations.ENTITY;
    }

    @Override
    public EntityArchetype copy() {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        builder.entityType = (EntityType)this.type;
        builder.entityData = NbtTranslator.getInstance().translate(this.data);
        return builder.build();
    }
}

