/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.spongepowered.common.event.tracking.context.ICaptureSupplier;

public abstract class CapturedMultiMapSupplier<K, V>
implements Supplier<ArrayListMultimap<K, V>>,
ICaptureSupplier {
    @Nullable
    private ArrayListMultimap<K, V> captured;

    protected CapturedMultiMapSupplier() {
    }

    @Override
    public ArrayListMultimap<K, V> get() {
        if (this.captured == null) {
            this.captured = ArrayListMultimap.create();
        }
        return this.captured;
    }

    @Override
    public final boolean isEmpty() {
        return this.captured == null || this.captured.isEmpty();
    }

    public final void acceptAndClearIfNotEmpty(Consumer<ListMultimap<K, V>> consumer) {
        if (this.captured != null && !this.captured.isEmpty()) {
            ArrayListMultimap consumed = ArrayListMultimap.create(this.captured);
            this.captured.clear();
            consumer.accept((ListMultimap<K, V>)consumed);
        }
    }

    public final void acceptAndClearIfNotEmpty(BiConsumer<K, V> consumer) {
        if (this.captured != null && !this.captured.isEmpty()) {
            ArrayListMultimap consumed = ArrayListMultimap.create(this.captured);
            this.captured.clear();
            consumed.forEach(consumer);
        }
    }

    public final void acceptIfNotEmpty(BiConsumer<K, List<V>> biConsumer) {
        if (this.captured != null && !this.captured.isEmpty()) {
            ArrayListMultimap consumed = ArrayListMultimap.create(this.captured);
            this.captured.clear();
            for (Map.Entry entry : consumed.asMap().entrySet()) {
                if (((Collection)entry.getValue()).isEmpty()) continue;
                biConsumer.accept(entry.getKey(), (List)entry.getValue());
            }
        }
    }

    public final void acceptIfNotEmpty(Consumer<ListMultimap<K, V>> consumer) {
        if (this.captured != null && !this.captured.isEmpty()) {
            consumer.accept((ListMultimap<K, V>)this.captured);
        }
    }

    public final void acceptAndRemoveIfPresent(K key, Consumer<List<V>> consumer) {
        List values;
        if (this.captured != null && !this.captured.isEmpty() && !(values = this.captured.removeAll(key)).isEmpty()) {
            consumer.accept(values);
        }
    }

    public final void acceptAndRemoveOrNewList(K key, Consumer<List<V>> consumer) {
        if (this.isEmpty()) {
            consumer.accept(new ArrayList());
            return;
        }
        List values = this.captured.removeAll(key);
        if (!values.isEmpty()) {
            consumer.accept(values);
        } else {
            consumer.accept(new ArrayList());
        }
    }

    public final void removeAllIfNotEmpty(K key) {
        if (this.isEmpty()) {
            return;
        }
        this.captured.removeAll(key);
    }

    public final ListMultimap<K, V> orElse(ListMultimap<K, V> list) {
        return this.captured == null ? list : (this.captured.isEmpty() ? list : this.captured);
    }

    public final Stream<V> stream(K key) {
        return this.captured == null ? Stream.empty() : this.captured.get(key).stream();
    }

    @Nullable
    public final <U> U mapIfPresent(K key, Function<List<V>, ? extends U> function) {
        if (this.isEmpty()) {
            return null;
        }
        List values = this.captured.get(key);
        if (values.isEmpty()) {
            return null;
        }
        return function.apply(values);
    }

    public int hashCode() {
        return Objects.hashCode(this.captured);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CapturedMultiMapSupplier other = (CapturedMultiMapSupplier)obj;
        return Objects.equals(this.captured, other.captured);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Captured", this.captured == null ? 0 : this.captured.size()).toString();
    }
}

