/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.entity.EntityContext;
import org.spongepowered.common.registry.type.event.SpawnTypeRegistryModule;

public abstract class EntityPhaseState<E extends EntityContext<E>>
implements IPhaseState<E> {
    private final String className = this.getClass().getSimpleName();

    @Override
    public final TrackingPhase getPhase() {
        return TrackingPhases.ENTITY;
    }

    @Override
    public boolean doesCaptureEntityDrops(E context) {
        return true;
    }

    @Nullable
    public Entity returnTeleportResult(PhaseContext<?> context, MoveEntityEvent.Teleport.Portal event) {
        return null;
    }

    @Override
    public void unwind(E context) {
    }

    public String toString() {
        return this.getPhase() + "{" + this.className + "}";
    }

    void standardSpawnCapturedEntities(PhaseContext<?> context, List<org.spongepowered.api.entity.Entity> entities) {
        List other;
        List<org.spongepowered.api.entity.Entity> experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
        if (!experience.isEmpty()) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
            SpongeCommonEventFactory.callSpawnEntity(experience, context);
        }
        if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypeRegistryModule.ENTITY_DEATH);
            SpongeCommonEventFactory.callSpawnEntity(experience, context);
        }
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

