/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

public final class PlaceBlockPacketState
extends BasicPacketState {
    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        CPacketPlayerTryUseItemOnBlock placeBlock = (CPacketPlayerTryUseItemOnBlock)packet;
        net.minecraft.item.ItemStack itemUsed = playerMP.func_184586_b(placeBlock.func_187022_c());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.func_187022_c();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<BlockSnapshot> transaction, BasicPacketContext context) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        Location<World> location = transaction.getFinal().getLocation().get();
        BlockPos pos = VecHelper.toBlockPos(location);
        IMixinChunk spongeChunk = (IMixinChunk)((WorldServer)location.getExtent()).func_175726_f(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.OWNER);
        }
        spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public void appendNotifierToBlockEvent(BasicPacketContext context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        BlockState state = ((World)((Object)mixinWorldServer)).getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((World)((Object)mixinWorldServer)).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state(state).build();
        blockEvent.setTickBlock(locatable);
        blockEvent.setSourceUser(player);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        Object packet = context.getPacket();
        EntityPlayerMP player = context.getPacketPlayer();
        IMixinWorldServer mixinWorld = (IMixinWorldServer)player.field_70170_p;
        ItemStack itemStack = context.getItemUsed();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
        HandType hand = context.getHandUsed();
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(player);
                frame.addContext(EventContextKeys.PLAYER_PLACE, (World)player.field_70170_p);
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.SPAWN_EGG);
                frame.addContext(EventContextKeys.USED_HAND, hand);
                frame.addContext(EventContextKeys.USED_ITEM, snapshot);
                SpongeCommonEventFactory.callSpawnEntity(entities, context);
            }
        });
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(originalBlocks -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(player);
                frame.addContext(EventContextKeys.PLAYER_PLACE, (World)player.field_70170_p);
                frame.addContext(EventContextKeys.USED_HAND, hand);
                frame.addContext(EventContextKeys.USED_ITEM, snapshot);
                boolean success = TrackingUtil.processBlockCaptures(originalBlocks, this, context);
                if (!success && snapshot != ItemTypeRegistryModule.NONE_SNAPSHOT) {
                    PacketPhaseUtil.handlePlayerSlotRestore(player, (net.minecraft.item.ItemStack)itemStack, (EnumHand)hand);
                }
            }
        });
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List<Entity> entities = drops.stream().map(drop -> drop.create(player.func_71121_q())).map(EntityUtil::fromNative).collect(Collectors.toList());
            if (!entities.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(player);
                    frame.addContext(EventContextKeys.PLAYER_PLACE, (World)player.field_70170_p);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                    frame.addContext(EventContextKeys.USED_HAND, hand);
                    frame.addContext(EventContextKeys.USED_ITEM, snapshot);
                    SpongeCommonEventFactory.callDropItemCustom(entities, context, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
                }
            }
        });
        IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
        mixinContainer.setCaptureInventory(false);
        mixinContainer.getCapturedTransactions().clear();
    }
}

