/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhaseContext;

public class ListenerPhaseContext
extends PluginPhaseContext<ListenerPhaseContext> {
    Object object;
    private CapturePlayer capturePlayer;

    ListenerPhaseContext(IPhaseState<ListenerPhaseContext> state) {
        super(state);
    }

    public ListenerPhaseContext event(Object obj) {
        this.object = obj;
        return this;
    }

    public ListenerPhaseContext player() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.capturePlayer == null ? 1 : 0) != 0, (Object)"Already capturing a player object!");
        this.capturePlayer = new CapturePlayer();
        return this;
    }

    public CapturePlayer getCapturedPlayerSupplier() throws IllegalStateException {
        if (this.capturePlayer == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing a Player from an event listener, but we're not capturing them!", this).get();
        }
        return this.capturePlayer;
    }

    public Optional<Player> getCapturedPlayer() throws IllegalStateException {
        return this.getCapturedPlayerSupplier().getPlayer();
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "Listener", this.object).add(s + "- %s: %s", "CapturePlayer", this.capturePlayer);
    }

    public static final class CapturePlayer {
        @Nullable
        private Player player;

        CapturePlayer() {
        }

        CapturePlayer(@Nullable Player player) {
            this.player = player;
        }

        public Optional<Player> getPlayer() {
            return Optional.ofNullable(this.player);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturePlayer that = (CapturePlayer)o;
            return Objects.equal((Object)this.player, (Object)that.player);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.player});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("player", (Object)this.player).toString();
        }

        public void addPlayer(EntityPlayerMP playerMP) {
            this.player = (Player)playerMP;
        }
    }
}

