/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.InventoryIterator;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.item.inventory.lens.CompoundSlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.lens.impl.fabric.CompoundFabric;
import org.spongepowered.common.item.inventory.query.Query;
import org.spongepowered.common.item.inventory.query.operation.LensQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.SlotLensQueryOperation;

public interface MinecraftInventoryAdapter
extends InventoryAdapter {
    @Override
    default public Translation getName() {
        if (this.getRootLens() == null) {
            return this.getFabric().getDisplayName();
        }
        return this.getRootLens().getName(this.getFabric());
    }

    @Override
    default public Inventory root() {
        return this.parent() == this ? this : this.parent().root();
    }

    @Override
    default public Optional<ItemStack> poll() {
        return AdapterLogic.pollSequential(this);
    }

    @Override
    default public Optional<ItemStack> poll(int limit) {
        return AdapterLogic.pollSequential(this, limit);
    }

    @Override
    default public Optional<ItemStack> peek() {
        return AdapterLogic.peekSequential(this);
    }

    @Override
    default public Optional<ItemStack> peek(int limit) {
        return AdapterLogic.peekSequential(this, limit);
    }

    @Override
    default public InventoryTransactionResult offer(ItemStack stack) {
        return AdapterLogic.appendSequential(this, stack);
    }

    @Override
    default public boolean canFit(ItemStack stack) {
        return AdapterLogic.canFit(this, stack);
    }

    @Override
    default public InventoryTransactionResult set(ItemStack stack) {
        return AdapterLogic.insertSequential(this, stack);
    }

    @Override
    default public int size() {
        return AdapterLogic.countStacks(this);
    }

    @Override
    default public int totalItems() {
        return AdapterLogic.countItems(this);
    }

    @Override
    default public int capacity() {
        return AdapterLogic.getCapacity(this);
    }

    @Override
    default public boolean hasChildren() {
        return this.getRootLens().getChildren().size() != 0;
    }

    @Override
    default public boolean contains(ItemStack stack) {
        return AdapterLogic.contains((InventoryAdapter)this, stack);
    }

    @Override
    default public boolean containsAny(ItemStack stack) {
        return AdapterLogic.contains(this, stack, 1);
    }

    @Override
    default public boolean contains(ItemType type) {
        return AdapterLogic.contains((InventoryAdapter)this, type);
    }

    @Override
    default public int getMaxStackSize() {
        return this.getRootLens().getMaxStackSize(this.getFabric());
    }

    @Override
    default public void setMaxStackSize(int size) {
        throw new UnsupportedOperationException("This inventory does not support stack limit adjustment");
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Inventory child, Class<T> property) {
        return AdapterLogic.getProperties(this, child, property);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Class<T> property) {
        if (this.parent() == this) {
            return AdapterLogic.getRootProperties(this, property);
        }
        return this.parent().getProperties(this, property);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Inventory child, Class<T> property, Object key) {
        for (InventoryProperty<?, ?> prop : AdapterLogic.getProperties(this, child, property)) {
            if (!key.equals(prop.getKey())) continue;
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Class<T> property, Object key) {
        if (this.parent() == this) {
            return AdapterLogic.getRootProperty(this, property, key);
        }
        return this.parent().getProperty(this, property, key);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Inventory child, Class<T> property) {
        Object key = AbstractInventoryProperty.getDefaultKey(property);
        return this.getProperty(child, property, key);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Class<T> property) {
        Object key = AbstractInventoryProperty.getDefaultKey(property);
        return this.getProperty(property, key);
    }

    @Override
    default public Iterator<Inventory> iterator() {
        return new InventoryIterator(this.getRootLens(), this.getFabric(), this);
    }

    @Override
    @Deprecated
    default public <T extends Inventory> T first() {
        return (T)this.iterator().next();
    }

    @Override
    @Deprecated
    default public <T extends Inventory> T next() {
        return (T)new EmptyInventoryImpl(this);
    }

    @Override
    default public <T extends Inventory> T query(QueryOperation<?> ... queries) {
        return (T)Query.compile(this, queries).execute();
    }

    @Override
    default public Inventory intersect(Inventory inventory) {
        return Query.compile(this, new SlotLensQueryOperation((ImmutableSet<Inventory>)ImmutableSet.of((Object)inventory))).execute();
    }

    @Override
    default public Inventory union(Inventory inventory) {
        CompoundLens.Builder lensBuilder = CompoundLens.builder().add(this.getRootLens());
        CompoundFabric fabric = new CompoundFabric((MinecraftFabric)this.getFabric(), (MinecraftFabric)((InventoryAdapter)inventory).getFabric());
        CompoundSlotProvider provider = new CompoundSlotProvider().add(this);
        for (Object inv : inventory) {
            lensBuilder.add(((InventoryAdapter)inv).getRootLens());
            provider.add((InventoryAdapter)inv);
        }
        CompoundLens lens = lensBuilder.build(provider);
        InventoryAdapter compoundAdapter = lens.getAdapter(fabric, this);
        return Query.compile(compoundAdapter, new SlotLensQueryOperation((ImmutableSet<Inventory>)ImmutableSet.of((Object)compoundAdapter))).execute();
    }

    @Override
    default public boolean containsInventory(Inventory inventory) {
        Inventory result = Query.compile(this, new LensQueryOperation(((InventoryAdapter)inventory).getRootLens())).execute();
        return result.capacity() == inventory.capacity() && ((InventoryAdapter)result).getRootLens() == ((InventoryAdapter)inventory).getRootLens();
    }

    @Override
    default public InventoryArchetype getArchetype() {
        return InventoryArchetypes.UNKNOWN;
    }
}

