/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.VanillaAdapter;
import org.spongepowered.common.item.inventory.lens.CompoundSlotProvider;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.ConceptualLens;

public class CompoundLens
extends ConceptualLens {
    protected final List<Lens> inventories;

    private CompoundLens(int size, Class<? extends Inventory> adapterType, SlotProvider slots, List<Lens> lenses) {
        super(0, size, adapterType, slots);
        this.inventories = lenses;
        this.init(slots);
    }

    @Override
    protected void init(SlotProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            if (!this.children.contains(slots.getSlot(slot))) {
                this.addSpanningChild(slots.getSlot(slot), new SlotIndex(ord));
            }
            ++ord;
            ++slot;
        }
    }

    @Override
    public InventoryAdapter getAdapter(Fabric inv, Inventory parent) {
        return new VanillaAdapter(inv, this, parent);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Lens> lenses = new ArrayList<Lens>();

        public Builder add(Lens lens) {
            this.lenses.add(lens);
            return this;
        }

        public CompoundLens build(CompoundSlotProvider provider) {
            return new CompoundLens(provider.size(), VanillaAdapter.class, provider, this.lenses);
        }
    }
}

