/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.fabric;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;

public class CompoundFabric
extends MinecraftFabric {
    private final MinecraftFabric fabric1;
    private final MinecraftFabric fabric2;
    private Translation displayName;

    public CompoundFabric(MinecraftFabric fabric1, MinecraftFabric fabric2) {
        this.fabric1 = fabric1;
        this.fabric2 = fabric2;
        this.displayName = fabric1.getDisplayName();
    }

    @Override
    public Collection<?> allInventories() {
        HashSet inv = new HashSet();
        inv.addAll(this.fabric1.allInventories());
        inv.addAll(this.fabric2.allInventories());
        return inv;
    }

    public IInventory get(int index) {
        if (index < this.fabric1.getSize()) {
            return (IInventory)this.fabric1.get(index);
        }
        return (IInventory)this.fabric2.get(index - this.fabric1.getSize());
    }

    @Override
    public ItemStack getStack(int index) {
        if (index < this.fabric1.getSize()) {
            return this.fabric1.getStack(index);
        }
        return this.fabric2.getStack(index - this.fabric1.getSize());
    }

    @Override
    public void setStack(int index, ItemStack stack) {
        if (index < this.fabric1.getSize()) {
            this.fabric1.setStack(index, stack);
        } else {
            this.fabric2.setStack(index - this.fabric1.getSize(), stack);
        }
    }

    @Override
    public int getMaxStackSize() {
        return Math.max(this.fabric1.getMaxStackSize(), this.fabric2.getMaxStackSize());
    }

    @Override
    public Translation getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getSize() {
        return this.fabric1.getSize() + this.fabric2.getSize();
    }

    @Override
    public void clear() {
        this.fabric1.clear();
        this.fabric2.clear();
    }

    @Override
    public void markDirty() {
        this.fabric1.markDirty();
        this.fabric2.markDirty();
    }
}

