/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.fabric;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;

public class EquipmentSlotsFabric
implements Fabric {
    private static final EntityEquipmentSlot[] SLOTS;
    private static final int MAX_STACK_SIZE = 64;
    private final Living living;

    public EquipmentSlotsFabric(Living living) {
        this.living = living;
    }

    public Collection<Living> allInventories() {
        return Collections.singleton(this.living);
    }

    public Living get(int index) {
        return this.living;
    }

    @Override
    public ItemStack getStack(int index) {
        return EntityUtil.toNative(this.living).func_184582_a(SLOTS[index]);
    }

    @Override
    public void setStack(int index, ItemStack stack) {
        EntityUtil.toNative(this.living).func_184201_a(SLOTS[index], stack);
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public Translation getDisplayName() {
        return SlotLensImpl.SLOT_NAME;
    }

    @Override
    public int getSize() {
        return SLOTS.length;
    }

    @Override
    public void clear() {
        EntityLivingBase entity = EntityUtil.toNative(this.living);
        for (EntityEquipmentSlot slot : SLOTS) {
            entity.func_184201_a(slot, ItemStack.field_190927_a);
        }
    }

    @Override
    public void markDirty() {
    }

    static {
        EntityEquipmentSlot[] values = EntityEquipmentSlot.values();
        SLOTS = new EntityEquipmentSlot[values.length];
        EntityEquipmentSlot[] entityEquipmentSlotArray = values;
        int n = entityEquipmentSlotArray.length;
        for (int i = 0; i < n; ++i) {
            EntityEquipmentSlot slot;
            EquipmentSlotsFabric.SLOTS[slot.func_188452_c()] = slot = entityEquipmentSlotArray[i];
        }
    }
}

