/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.crafting.Ingredient;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.item.recipe.crafting.CustomIngredient;
import org.spongepowered.common.item.recipe.crafting.IngredientUtil;

public class SpongeIngredientBuilder
implements Ingredient.Builder {
    private List<Predicate<ItemStack>> predicates = new ArrayList<Predicate<ItemStack>>();
    private List<ItemStack> matchItems = new ArrayList<ItemStack>();
    private List<ItemStack> displayItems = new ArrayList<ItemStack>();

    @Override
    public Ingredient.Builder from(org.spongepowered.api.item.recipe.crafting.Ingredient value) {
        this.reset();
        Class<?> ingredientClass = value.getClass();
        if (ingredientClass == Ingredient.class) {
            this.matchItems.addAll(ItemStackUtil.fromNative(IngredientUtil.toNative((org.spongepowered.api.item.recipe.crafting.Ingredient)value).field_193371_b));
            this.displayItems.addAll(this.matchItems);
        } else if (ingredientClass == CustomIngredient.class) {
            CustomIngredient custom = (CustomIngredient)((Object)value);
            this.displayItems = ItemStackUtil.fromNative(custom.field_193371_b);
            this.predicates = custom.predicates;
            this.matchItems = custom.matchItems;
        } else if (Ingredient.class.isAssignableFrom(ingredientClass)) {
            this.displayItems.addAll(ItemStackUtil.fromNative(IngredientUtil.toNative((org.spongepowered.api.item.recipe.crafting.Ingredient)value).field_193371_b));
            this.predicates.add(value);
        } else {
            this.predicates.add(value);
        }
        return this;
    }

    @Override
    public Ingredient.Builder reset() {
        this.predicates.clear();
        this.matchItems.clear();
        this.displayItems.clear();
        return this;
    }

    @Override
    public Ingredient.Builder with(Predicate<ItemStack> predicate) {
        this.predicates.add(predicate);
        this.displayItems.clear();
        return this;
    }

    @Override
    public Ingredient.Builder with(ItemStackSnapshot ... items) {
        Arrays.stream(items).map(ItemStackSnapshot::createStack).forEach(this.matchItems::add);
        return this.withDisplay(items);
    }

    @Override
    public Ingredient.Builder with(ItemStack ... items) {
        Arrays.stream(items).map(ItemStack::copy).forEach(this.matchItems::add);
        return this.withDisplay(items);
    }

    @Override
    public Ingredient.Builder with(ItemType ... items) {
        Arrays.stream(items).map(t -> t::matches).forEach(this.predicates::add);
        return this.withDisplay(items);
    }

    @Override
    public Ingredient.Builder withDisplay(ItemStack ... items) {
        Arrays.stream(items).map(ItemStack::copy).forEach(this.displayItems::add);
        return this;
    }

    @Override
    public Ingredient.Builder withDisplay(ItemType ... types) {
        Arrays.stream(types).map(t -> ItemStack.of(t, 1)).forEach(this.displayItems::add);
        return this;
    }

    @Override
    public Ingredient.Builder withDisplay(ItemStackSnapshot ... items) {
        Arrays.stream(items).map(ItemStackSnapshot::createStack).forEach(this.displayItems::add);
        return this;
    }

    @Override
    public org.spongepowered.api.item.recipe.crafting.Ingredient build() {
        if (this.predicates.isEmpty() && this.matchItems.equals(this.displayItems)) {
            net.minecraft.item.ItemStack[] stacks = (net.minecraft.item.ItemStack[])this.matchItems.stream().map(ItemStackUtil::toNative).toArray(net.minecraft.item.ItemStack[]::new);
            return IngredientUtil.fromNative(Ingredient.func_193369_a((net.minecraft.item.ItemStack[])stacks));
        }
        return IngredientUtil.fromNative(new CustomIngredient(this.predicates, this.matchItems, this.displayItems));
    }
}

