/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableGrowthData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeGrowthData;
import org.spongepowered.common.event.damage.MinecraftBlockDamageSource;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockCactus.class})
public abstract class MixinBlockCactus
extends MixinBlock {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"onEntityCollision"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean onSpongeCactusDamage(Entity entity, DamageSource source, float damage, World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (world.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            Location<org.spongepowered.api.world.World> location = new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            DamageSource.field_76367_g = new MinecraftBlockDamageSource("cactus", location);
            boolean bl = entity.func_70097_a(DamageSource.field_76367_g, damage);
            return bl;
        }
        finally {
            DamageSource.field_76367_g = source;
        }
    }

    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getGrowthData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableGrowthData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableGrowthData) {
            int growth = (Integer)((ImmutableGrowthData)manipulator).growthStage().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockCactus.field_176587_a, (Comparable)Integer.valueOf(growth)));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.GROWTH_STAGE)) {
            int growth = (Integer)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockCactus.field_176587_a, (Comparable)Integer.valueOf(growth)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableGrowthData getGrowthData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeGrowthData.class, blockState.func_177229_b((IProperty)BlockCactus.field_176587_a), 0, 15);
    }
}

