/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePortionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableSeamlessData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableSlabData;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.SlabType;
import org.spongepowered.api.data.type.SlabTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePortionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeSlabData;
import org.spongepowered.common.mixin.core.block.MixinBlock;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={BlockStoneSlabNew.class, BlockStoneSlab.class})
public abstract class MixinBlockStoneSlab
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getSlabTypeFor(blockState), (Object)this.getPortionTypeFor(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableSlabData.class.isAssignableFrom(immutable) || ImmutablePortionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableSlabData) {
            SlabType type = (SlabType)((ImmutableSlabData)manipulator).type().get();
            if (blockState.func_177230_c() instanceof BlockStoneSlab) {
                if (!type.equals(SlabTypes.RED_SAND)) {
                    BlockStoneSlab.EnumType slabType = (BlockStoneSlab.EnumType)type;
                    return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)slabType));
                }
            } else if (blockState.func_177230_c() instanceof BlockStoneSlabNew && type.equals(SlabTypes.RED_SAND)) {
                BlockStoneSlabNew.EnumType slabType = (BlockStoneSlabNew.EnumType)type;
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlabNew.field_176559_M, (Comparable)slabType));
            }
            return Optional.empty();
        }
        if (manipulator instanceof ImmutablePortionData) {
            PortionType portionType = (PortionType)((ImmutablePortionData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)((BlockSlab.EnumBlockHalf)portionType)));
        }
        if (manipulator instanceof ImmutableSeamlessData) {
            boolean seamless = (Boolean)((ImmutableSeamlessData)manipulator).seamless().get();
            if (blockState.func_177230_c() instanceof BlockStoneSlab) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(seamless)));
            }
            if (blockState.func_177230_c() instanceof BlockStoneSlabNew) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlabNew.field_176558_b, (Comparable)Boolean.valueOf(seamless)));
            }
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.SLAB_TYPE)) {
            SlabType type = (SlabType)value;
            if (blockState.func_177230_c() instanceof BlockStoneSlab) {
                if (!type.equals(SlabTypes.RED_SAND)) {
                    BlockStoneSlab.EnumType slabType = (BlockStoneSlab.EnumType)value;
                    return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)slabType));
                }
            } else if (blockState.func_177230_c() instanceof BlockStoneSlabNew && type.equals(SlabTypes.RED_SAND)) {
                BlockStoneSlabNew.EnumType slabType = (BlockStoneSlabNew.EnumType)value;
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlabNew.field_176559_M, (Comparable)slabType));
            }
            return Optional.empty();
        }
        if (key.equals(Keys.PORTION_TYPE)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)((BlockSlab.EnumBlockHalf)value)));
        }
        if (key.equals(Keys.SEAMLESS)) {
            boolean seamless = (Boolean)value;
            if (blockState.func_177230_c() instanceof BlockStoneSlab) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(seamless)));
            }
            if (blockState.func_177230_c() instanceof BlockStoneSlabNew) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStoneSlabNew.field_176558_b, (Comparable)Boolean.valueOf(seamless)));
            }
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableSlabData getSlabTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeSlabData.class, blockState.func_177230_c() instanceof BlockStoneSlab ? (SlabType)((Object)blockState.func_177229_b((IProperty)BlockStoneSlab.field_176556_M)) : (blockState.func_177230_c() instanceof BlockStoneSlabNew ? (SlabType)((Object)blockState.func_177229_b((IProperty)BlockStoneSlabNew.field_176559_M)) : SlabTypes.COBBLESTONE));
    }

    private ImmutablePortionData getPortionTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePortionData.class, blockState.func_177229_b((IProperty)BlockSlab.field_176554_a));
    }

    @Override
    public Translation getTranslation() {
        if (this.func_176194_O().func_177622_c() instanceof BlockStoneSlabNew) {
            return new SpongeTranslation(this.func_149739_a() + ".red_sandstone.name");
        }
        return super.getTranslation();
    }
}

