/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import net.minecraft.block.BlockTNT;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.entity.IMixinEntityTNTPrimed;
import org.spongepowered.common.interfaces.entity.explosive.IMixinFusedExplosive;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockTNT.class})
public abstract class MixinBlockTNT
extends MixinBlock {
    private static final String TARGET_PRIME = "Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z";
    private static final String TARGET_PRIME_SOUND = "Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V";
    private static final String TARGET_REMOVE = "Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z";
    private static final String TARGET_REMOVE_BLOCK = "Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
    private EntityLivingBase igniter;
    private boolean primeCancelled;

    private boolean onRemove(World world, BlockPos pos) {
        boolean removed = !this.primeCancelled && world.func_175698_g(pos);
        this.primeCancelled = false;
        return removed;
    }

    @Inject(method={"explode"}, at={@At(value="INVOKE")})
    public void prePrime(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter, CallbackInfo ci) {
        this.igniter = igniter;
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z"))
    public boolean onPrime(World world, Entity tnt) {
        IMixinEntityTNTPrimed mixin = (IMixinEntityTNTPrimed)tnt;
        mixin.setDetonator(this.igniter);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (this.igniter != null) {
                frame.addContext(EventContextKeys.IGNITER, (Living)this.igniter);
            }
            this.primeCancelled = !mixin.shouldPrime();
        }
        return !this.primeCancelled && world.func_72838_d(tnt);
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    public void onPrimeSound(World world, EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        if (!this.primeCancelled) {
            world.func_184148_a(null, x, y, z, soundIn, category, volume, pitch);
        }
    }

    @Redirect(method={"onExplosionDestroy"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z"))
    public boolean onPrimePostExplosion(World world, Entity tnt) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            boolean result;
            frame.addContext(EventContextKeys.DAMAGE_TYPE, DamageTypes.EXPLOSIVE);
            boolean bl = result = ((IMixinFusedExplosive)tnt).shouldPrime() && world.func_72838_d(tnt);
            return bl;
        }
    }

    @Redirect(method={"onBlockAdded"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z"))
    public boolean onRemovePostAddded(World world, BlockPos pos) {
        return this.onRemove(world, pos);
    }

    @Redirect(method={"neighborChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z"))
    public boolean onRemovePostCharge(World world, BlockPos pos) {
        return this.onRemove(world, pos);
    }

    @Redirect(method={"onBlockActivated"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"))
    public boolean onRemovePostInteract(World world, BlockPos pos, IBlockState state, int flag) {
        boolean removed = !this.primeCancelled && world.func_180501_a(pos, state, flag);
        this.primeCancelled = false;
        return removed;
    }

    @Redirect(method={"onEntityCollision"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z"))
    public boolean onRemovePostCollision(World world, BlockPos pos) {
        return this.onRemove(world, pos);
    }
}

