/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.AgentData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.Goal;
import org.spongepowered.api.entity.ai.GoalType;
import org.spongepowered.api.entity.ai.GoalTypes;
import org.spongepowered.api.entity.ai.task.AITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.LeashEntityEvent;
import org.spongepowered.api.event.entity.UnleashEntityEvent;
import org.spongepowered.api.event.entity.ai.AITaskEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAgentData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.ai.IMixinEntityAIBase;
import org.spongepowered.common.interfaces.ai.IMixinEntityAITasks;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.core.entity.MixinEntityLivingBase;

@Mixin(value={EntityLiving.class})
public abstract class MixinEntityLiving
extends MixinEntityLivingBase
implements Agent {
    private static final String GET_CLOSEST_PLAYER = "Lnet/minecraft/world/World;getClosestPlayerToEntity(Lnet/minecraft/entity/Entity;D)Lnet/minecraft/entity/player/EntityPlayer;";
    @Shadow
    @Final
    private EntityAITasks field_70714_bg;
    @Shadow
    @Final
    private EntityAITasks field_70715_bh;
    @Shadow
    @Nullable
    private EntityLivingBase field_70696_bz;

    @Shadow
    public abstract boolean func_175446_cd();

    @Shadow
    @Nullable
    public abstract net.minecraft.entity.Entity func_110166_bE();

    @Shadow
    protected abstract void func_184651_r();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLiving;initEntityAI()V"))
    public void onInitAi(EntityLiving this$0) {
        this.initSpongeAI();
        this.func_184651_r();
    }

    private void initSpongeAI() {
        if (!((IMixinEntityAITasks)this.field_70714_bg).initialized()) {
            ((IMixinEntityAITasks)this.field_70714_bg).setOwner((EntityLiving)this);
            ((IMixinEntityAITasks)this.field_70714_bg).setType(GoalTypes.NORMAL);
            ((IMixinEntityAITasks)this.field_70714_bg).setInitialized(true);
        }
        if (!((IMixinEntityAITasks)this.field_70715_bh).initialized()) {
            ((IMixinEntityAITasks)this.field_70715_bh).setOwner((EntityLiving)this);
            ((IMixinEntityAITasks)this.field_70715_bh).setType(GoalTypes.TARGET);
            ((IMixinEntityAITasks)this.field_70715_bh).setInitialized(true);
        }
    }

    @Override
    public void firePostConstructEvents() {
        super.firePostConstructEvents();
        if (ShouldFire.A_I_TASK_EVENT_ADD) {
            this.handleDelayedTaskEventFiring((IMixinEntityAITasks)this.field_70714_bg);
            this.handleDelayedTaskEventFiring((IMixinEntityAITasks)this.field_70715_bh);
        }
    }

    private void handleDelayedTaskEventFiring(IMixinEntityAITasks tasks) {
        Iterator<EntityAITasks.EntityAITaskEntry> taskItr = tasks.getTasksUnsafe().iterator();
        while (taskItr.hasNext()) {
            EntityAITasks.EntityAITaskEntry task = taskItr.next();
            AITaskEvent.Add event = SpongeEventFactory.createAITaskEventAdd(Sponge.getCauseStackManager().getCurrentCause(), task.field_75731_b, task.field_75731_b, (Goal)((Object)tasks), this, (AITask)task.field_75733_a);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) continue;
            ((IMixinEntityAIBase)task.field_75733_a).setGoal(null);
            taskItr.remove();
        }
    }

    @Inject(method={"processInitialInteract"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLiving;setLeashHolder(Lnet/minecraft/entity/Entity;Z)V")})
    public void callLeashEvent(EntityPlayer playerIn, EnumHand hand, CallbackInfoReturnable<Boolean> ci) {
        if (!playerIn.field_70170_p.field_72995_K) {
            Sponge.getCauseStackManager().pushCause(playerIn);
            LeashEntityEvent event = SpongeEventFactory.createLeashEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), this);
            SpongeImpl.postEvent(event);
            Sponge.getCauseStackManager().popCause();
            if (event.isCancelled()) {
                ci.setReturnValue(false);
            }
        }
    }

    @Inject(method={"clearLeashed"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/EntityLiving;isLeashed:Z", opcode=181)}, cancellable=true)
    public void callUnleashEvent(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        net.minecraft.entity.Entity entity = this.func_110166_bE();
        if (!this.field_70170_p.field_72995_K) {
            if (entity == null) {
                Sponge.getCauseStackManager().pushCause(this);
            } else {
                Sponge.getCauseStackManager().pushCause(entity);
            }
            UnleashEntityEvent event = SpongeEventFactory.createUnleashEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), this);
            SpongeImpl.postEvent(event);
            Sponge.getCauseStackManager().popCause();
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Override
    public <T extends Agent> Optional<Goal<T>> getGoal(GoalType type) {
        if (GoalTypes.NORMAL.equals(type)) {
            return Optional.of((Goal)this.field_70714_bg);
        }
        if (GoalTypes.TARGET.equals(type)) {
            return Optional.of((Goal)this.field_70715_bh);
        }
        return Optional.empty();
    }

    @ModifyConstant(method={"despawnEntity"}, constant={@Constant(doubleValue=16384.0)})
    private double getHardDespawnRange(double value) {
        if (!this.field_70170_p.field_72995_K) {
            return Math.pow(((IMixinWorldServer)this.field_70170_p).getWorldConfig().getConfig().getEntity().getHardDespawnRange(), 2.0);
        }
        return value;
    }

    @ModifyConstant(method={"despawnEntity"}, constant={@Constant(doubleValue=1024.0)}, expect=2)
    private double getSoftDespawnRange(double value) {
        if (!this.field_70170_p.field_72995_K) {
            return Math.pow(((IMixinWorldServer)this.field_70170_p).getWorldConfig().getConfig().getEntity().getSoftDespawnRange(), 2.0);
        }
        return value;
    }

    @ModifyConstant(method={"despawnEntity"}, constant={@Constant(intValue=600)})
    private int getMinimumLifetime(int value) {
        if (!this.field_70170_p.field_72995_K) {
            return ((IMixinWorldServer)this.field_70170_p).getWorldConfig().getConfig().getEntity().getMinimumLife() * 20;
        }
        return value;
    }

    @Nullable
    @Redirect(method={"despawnEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getClosestPlayerToEntity(Lnet/minecraft/entity/Entity;D)Lnet/minecraft/entity/player/EntityPlayer;"))
    public EntityPlayer onDespawnEntity(World world, net.minecraft.entity.Entity entity, double distance) {
        return ((IMixinWorld)world).getClosestPlayerToEntityWhoAffectsSpawning(entity, distance);
    }

    @Override
    public Optional<Entity> getTarget() {
        return Optional.ofNullable((Entity)this.field_70696_bz);
    }

    @Override
    public void setTarget(@Nullable Entity target) {
        this.field_70696_bz = target instanceof EntityLivingBase ? (EntityLivingBase)target : null;
    }

    @Inject(method={"setAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetAttackTarget(@Nullable EntityLivingBase entitylivingbaseIn, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K && ShouldFire.SET_A_I_TARGET_EVENT && entitylivingbaseIn != null) {
            if (((IMixinEntity)entitylivingbaseIn).isVanished() && ((IMixinEntity)entitylivingbaseIn).isUntargetable()) {
                this.field_70696_bz = null;
                ci.cancel();
            } else {
                SetAITargetEvent event = SpongeCommonEventFactory.callSetAttackTargetEvent((Entity)entitylivingbaseIn, this);
                if (event.isCancelled()) {
                    ci.cancel();
                } else {
                    this.field_70696_bz = event.getTarget().orElse(null);
                }
            }
        }
    }

    @Nullable
    @Overwrite
    public EntityLivingBase func_70638_az() {
        if (this.field_70696_bz != null && ((IMixinEntity)this.field_70696_bz).isVanished() && ((IMixinEntity)this.field_70696_bz).isUntargetable()) {
            this.field_70696_bz = null;
        }
        return this.field_70696_bz;
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLiving;canPickUpLoot()Z"))
    private boolean onCanGrief(EntityLiving thisEntity) {
        return thisEntity.func_98052_bS() && ((IMixinGriefer)((Object)this)).canGrief();
    }

    @Override
    public AgentData getAgentData() {
        return new SpongeAgentData(!this.func_175446_cd());
    }

    @Override
    public Value<Boolean> aiEnabled() {
        return new SpongeValue<Boolean>(Keys.AI_ENABLED, true, !this.func_175446_cd());
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getAgentData());
    }

    @Override
    public void onJoinWorld() {
        this.initSpongeAI();
    }
}

