/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Rotations;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.ArmorStandData;
import org.spongepowered.api.data.manipulator.mutable.entity.BodyPartRotationalData;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeArmorStandData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeBodyPartRotationalData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.mixin.core.entity.MixinEntityLivingBase;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityArmorStand.class})
@Implements(value={@Interface(iface=ArmorStand.class, prefix="armor$")})
public abstract class MixinEntityArmorStand
extends MixinEntityLivingBase
implements ArmorStand {
    @Shadow
    public Rotations field_175438_bj;
    @Shadow
    public Rotations field_175439_bk;
    @Shadow
    public Rotations field_175440_bl;
    @Shadow
    public Rotations field_175441_bm;

    @Shadow
    public abstract boolean func_175402_q();

    @Shadow
    public abstract boolean func_175414_r();

    @Shadow
    public abstract boolean func_181026_s();

    @Shadow
    public abstract boolean shadow$func_175410_n();

    @Shadow
    public abstract Rotations shadow$func_175418_s();

    @Shadow
    public abstract Rotations func_175408_t();

    @Shadow
    protected abstract void func_175406_a(float var1);

    @Override
    public Value<Boolean> marker() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_MARKER, false, this.func_181026_s());
    }

    @Override
    public Value<Boolean> small() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_IS_SMALL, false, this.shadow$func_175410_n());
    }

    @Override
    public Value<Boolean> basePlate() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_HAS_BASE_PLATE, true, !this.func_175414_r());
    }

    @Override
    public Value<Boolean> arms() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_HAS_ARMS, false, this.func_175402_q());
    }

    @Override
    public ArmorStandData getArmorStandData() {
        return new SpongeArmorStandData(this.func_181026_s(), this.shadow$func_175410_n(), this.func_175402_q(), !this.func_175414_r());
    }

    @Override
    public BodyPartRotationalData getBodyPartRotationalData() {
        HashMap rotations = Maps.newHashMapWithExpectedSize((int)6);
        rotations.put(BodyParts.HEAD, VecHelper.toVector3d(this.shadow$func_175418_s()));
        rotations.put(BodyParts.CHEST, VecHelper.toVector3d(this.func_175408_t()));
        rotations.put(BodyParts.LEFT_ARM, VecHelper.toVector3d(this.field_175438_bj));
        rotations.put(BodyParts.RIGHT_ARM, VecHelper.toVector3d(this.field_175439_bk));
        rotations.put(BodyParts.LEFT_LEG, VecHelper.toVector3d(this.field_175440_bl));
        rotations.put(BodyParts.RIGHT_LEG, VecHelper.toVector3d(this.field_175441_bm));
        return new SpongeBodyPartRotationalData(rotations);
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getBodyPartRotationalData());
        manipulators.add(this.getArmorStandData());
    }

    private void fireDestroyDamageEvent(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), new ArrayList(), this, Math.max(1000.0f, this.func_110143_aJ()));
            if (SpongeImpl.postEvent(event)) {
                cir.setReturnValue(false);
            }
            if (event.getFinalDamage() < (double)this.func_110143_aJ()) {
                this.func_175406_a((float)event.getFinalDamage());
                cir.setReturnValue(false);
            }
        }
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/util/DamageSource;OUT_OF_WORLD:Lnet/minecraft/util/DamageSource;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;setDead()V", ordinal=0)}, cancellable=true)
    private void fireDamageEventOutOfWorld(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isExplosion()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;dropContents()V")}, cancellable=true)
    private void fireDamageEventExplosion(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;damageArmorStand(F)V"))
    private void fireDamageEventDamage(EntityArmorStand self, float effectiveAmount, DamageSource source, float originalAmount) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), new ArrayList(), this, effectiveAmount);
            if (!SpongeImpl.postEvent(event)) {
                this.func_175406_a((float)event.getFinalDamage());
            }
        }
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isCreativePlayer()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;playBrokenSound()V")}, cancellable=true)
    private void fireDamageEventCreativePunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"attackEntityFrom"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/item/EntityArmorStand;punchCooldown:J", opcode=180))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V")}, cancellable=true)
    private void fireDamageEventFirstPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), new ArrayList(), this, 0.0);
            if (SpongeImpl.postEvent(event)) {
                cir.setReturnValue(false);
            }
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityArmorStand;dropBlock()V")}, cancellable=true)
    private void fireDamageEventSecondPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Override
    @Overwrite
    public void func_174812_G() {
        super.func_174812_G();
    }
}

