/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.mixin.core.entity.projectile.MixinEntityThrowable;

@Mixin(value={EntityEnderPearl.class})
public abstract class MixinEntityEnderPearl
extends MixinEntityThrowable
implements EnderPearl {
    public double damageAmount;

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private float onAttackEntityFrom(float damage) {
        return (float)this.damageAmount;
    }

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;isPlayerSleeping()Z"))
    private boolean onEnderPearlImpact(EntityPlayerMP player) {
        if (player.func_70608_bn()) {
            return true;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.TELEPORT_TYPE, TeleportTypes.ENTITY_TELEPORT);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (Player)player);
            frame.addContext(EventContextKeys.THROWER, (Player)player);
            MoveEntityEvent.Teleport event = EntityUtil.handleDisplaceEntityTeleportEvent((Entity)player, this.getLocation());
            if (event.isCancelled()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_74764_b("damageAmount")) {
            this.damageAmount = compound.func_74769_h("damageAmount");
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74780_a("damageAmount", this.damageAmount);
    }
}

