/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={SlotCrafting.class})
public abstract class MixinSlotCrafting
extends Slot {
    @Shadow
    @Final
    private EntityPlayer field_75238_b;
    @Shadow
    @Final
    private InventoryCrafting field_75239_a;
    @Shadow
    private int field_75237_g;
    @Nullable
    private CraftingRecipe lastRecipe;
    @Nullable
    private ItemStack craftedStack;
    private int craftedStackQuantity;

    public MixinSlotCrafting(IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public void func_75215_d(@Nullable ItemStack stack) {
        super.func_75215_d(stack);
        if (this.field_75238_b instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.field_75238_b).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, 0, stack));
        }
    }

    @Inject(method={"onCrafting(Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private void onCraftingHead(ItemStack itemStack, CallbackInfo ci) {
        this.craftedStackQuantity = this.field_75237_g;
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void beforeTake(EntityPlayer thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        this.lastRecipe = (CraftingRecipe)CraftingManager.func_192413_b((InventoryCrafting)this.field_75239_a, (World)thePlayer.field_70170_p);
        if (((IMixinContainer)thePlayer.field_71070_bA).isShiftCrafting()) {
            ((IMixinContainer)thePlayer.field_71070_bA).detectAndSendChanges(true);
            ((IMixinContainer)thePlayer.field_71070_bA).setShiftCrafting(false);
        }
        ((IMixinContainer)thePlayer.field_71070_bA).setFirePreview(false);
        stack.func_190917_f(1);
        this.craftedStack = stack.func_77946_l();
        if (this.field_75237_g != 0) {
            this.craftedStackQuantity = this.field_75237_g;
        }
        this.craftedStack.func_190920_e(this.craftedStackQuantity);
        stack.func_190918_g(1);
    }

    @Redirect(method={"onTake"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/crafting/CraftingManager;getRemainingItems(Lnet/minecraft/inventory/InventoryCrafting;Lnet/minecraft/world/World;)Lnet/minecraft/util/NonNullList;"))
    private NonNullList<ItemStack> onGetRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        if (this.lastRecipe == null) {
            return NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        return CraftingManager.func_180303_b((InventoryCrafting)craftMatrix, (World)worldIn);
    }

    @Inject(method={"onTake"}, cancellable=true, at={@At(value="RETURN")})
    private void afterTake(EntityPlayer thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        ItemStackSnapshot craftedItem;
        if (((IMixinWorld)thePlayer.field_70170_p).isFake()) {
            return;
        }
        ((IMixinContainer)thePlayer.field_71070_bA).detectAndSendChanges(true);
        ((IMixinContainer)thePlayer.field_71070_bA).setCaptureInventory(false);
        Container container = thePlayer.field_71070_bA;
        Object craftInv = ((Inventory)container).query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeImpl.getLogger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        Transaction first = null;
        List<SlotTransaction> capturedTransactions = ((IMixinContainer)container).getCapturedTransactions();
        Iterator<SlotTransaction> iterator = capturedTransactions.iterator();
        while (iterator.hasNext()) {
            SlotTransaction trans = iterator.next();
            Optional<SlotIndex> slotIndex = trans.getSlot().getInventoryProperty(SlotIndex.class);
            if (!slotIndex.isPresent() || (Integer)slotIndex.get().getValue() != 0) continue;
            iterator.remove();
            if (first != null) continue;
            first = trans;
        }
        if (first != null) {
            capturedTransactions.add((SlotTransaction)first);
            craftedItem = (ItemStackSnapshot)((ItemStackSnapshot)first.getOriginal()).copy();
        } else {
            craftedItem = ItemStackUtil.snapshotOf(this.craftedStack);
        }
        CraftingInventory craftingInventory = (CraftingInventory)craftInv;
        CraftItemEvent.Craft event = SpongeCommonEventFactory.callCraftEventPost(thePlayer, craftingInventory, craftedItem, this.lastRecipe, container, capturedTransactions);
        ((IMixinContainer)container).setLastCraft(event);
        ((IMixinContainer)container).setFirePreview(true);
        this.craftedStack = null;
        List<SlotTransaction> previewTransactions = ((IMixinContainer)container).getPreviewTransactions();
        if (this.field_75239_a.func_191420_l()) {
            return;
        }
        SlotTransaction last = previewTransactions.isEmpty() ? new SlotTransaction(craftingInventory.getResult(), ItemStackSnapshot.NONE, ItemStackUtil.snapshotOf(this.func_75211_c())) : previewTransactions.get(0);
        CraftingRecipe newRecipe = (CraftingRecipe)CraftingManager.func_192413_b((InventoryCrafting)this.field_75239_a, (World)thePlayer.field_70170_p);
        SpongeCommonEventFactory.callCraftEventPre(thePlayer, craftingInventory, last, newRecipe, container, previewTransactions);
        previewTransactions.clear();
    }
}

