/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.chunk;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BitArray;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.NibbleArray;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinBlockStateContainer;

@Mixin(value={BlockStateContainer.class})
public abstract class MixinBlockStateContainer
implements IMixinBlockStateContainer {
    @Shadow
    private int field_186024_e;
    @Shadow
    protected IBlockStatePalette field_186022_c;
    @Shadow
    protected BitArray field_186021_b;

    @Shadow
    protected abstract void func_186014_b(int var1, IBlockState var2);

    @Override
    public int getBits() {
        return this.field_186024_e;
    }

    @Override
    public IBlockStatePalette getPalette() {
        return this.field_186022_c;
    }

    @Override
    public BitArray getStorage() {
        return this.field_186021_b;
    }

    @Redirect(method={"setDataFromNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/BlockStateContainer;set(ILnet/minecraft/block/state/IBlockState;)V"))
    private void setFixedBlockState(BlockStateContainer this_, int i, IBlockState state, byte[] id, NibbleArray meta, @Nullable NibbleArray add) {
        Object newState;
        if (state != null) {
            newState = state;
        } else {
            int x = i & 0xF;
            int y = i >> 8 & 0xF;
            int z = i >> 4 & 0xF;
            int idAdd = add == null ? 0 : add.func_76582_a(x, y, z);
            int blockId = idAdd << 8 | id[i] & 0xFF;
            Block block = (Block)Block.field_149771_c.func_148754_a(blockId);
            newState = block != null ? block.func_176223_P() : null;
        }
        this.func_186014_b(i, (IBlockState)newState);
    }

    @Redirect(method={"getSerializedSize"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/BitArray;size()I"))
    private int onGetStorageSize$FixVanillaBug(BitArray bits) {
        return bits.func_188143_a().length;
    }

    @Redirect(method={"write"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IBlockStatePalette;write(Lnet/minecraft/network/PacketBuffer;)V"))
    private void onPaletteWrite(IBlockStatePalette palette, PacketBuffer buffer) {
        int serializedSize = palette.func_186040_a();
        int index = buffer.writerIndex();
        try {
            palette.func_186037_b(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Attempted to serialize a block palette of size: " + serializedSize);
        }
        int newIndex = buffer.writerIndex();
        if (index + serializedSize != newIndex) {
            throw new IllegalStateException("Expected to have written " + serializedSize + " for a block palette, but instead wrote " + (newIndex - index));
        }
    }

    @Redirect(method={"write"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/PacketBuffer;writeLongArray([J)Lnet/minecraft/network/PacketBuffer;"))
    private PacketBuffer onSpongeWriteLongArrayPacketBuffer(PacketBuffer buffer, long[] backingArray) {
        int expectedSize = PacketBuffer.func_150790_a((int)backingArray.length);
        int lengthIndex = buffer.writerIndex();
        try {
            buffer.func_150787_b(backingArray.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Attempted to serialize the backing long array size but couldn't! Expected writer index(" + lengthIndex + ") with expected size(" + expectedSize + ") and current writer index(" + buffer.writerIndex() + ")");
        }
        int currentIndex = buffer.writerIndex();
        if (lengthIndex + expectedSize != currentIndex) {
            throw new IllegalStateException("Attempted to serialize a long array size incorrectly! Expected index to start " + lengthIndex + " with var int size of " + expectedSize + " but got " + (currentIndex - lengthIndex));
        }
        int arrayIndex = buffer.writerIndex();
        int expectedArraySize = backingArray.length * 8;
        for (int i = 0; i < backingArray.length; ++i) {
            int bufferIndex = buffer.writerIndex();
            long value = backingArray[i];
            if (bufferIndex + 8 > buffer.writableBytes()) {
                switch (buffer.ensureWritable(8, true)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        new PrettyPrinter(60).add("Unable to resize Buffer for SPackeetChunkData").centre().hr().addWrapped(60, "Sponge is attempting to recover from a potentially fatal issue with sending chunk packets. Because the cause of the issue is very difficult to find, Sponge is attempting to recover the buffer before it crashes. Since the buffer appears to be maxed out, no more data can be written to the buffer and therefor it must be returned.", new Object[0]).add().add("Please refer to the SpongeForge issue if this warning has been printed on yoru server, or the side effects of this warning.").trace();
                        throw new ArrayIndexOutOfBoundsException("Unable to resize packet buffer to fit more data. Current ");
                    }
                    case 2: {
                        SpongeImpl.getLogger().warn("Sponge is attempting to prevent a crash for sending chunk data to clients. Managed to increase the buffer size. Refer to SpongeForge Issue #2405");
                        break;
                    }
                    case 3: {
                        new PrettyPrinter(60).add("Unable to resize Buffer for SPackeetChunkData").centre().hr().addWrapped(60, "Sponge is attempting to recover from a potentially fatal issue with sending chunk packets. Because the cause of the issue is very difficult to find, Sponge is attempting to recover the buffer before it crashes. Since the buffer appears to be maxed out, no more data can be written to the buffer and therefor it must be returned.", new Object[0]).add().add("Please refer to the SpongeForge issue if this warning has been printed on yoru server, or the side effects of this warning.").trace();
                        SpongeImpl.getLogger().error("Unable to increase the size of the buffer to fit enough data.");
                        return buffer;
                    }
                }
            }
            try {
                buffer.writeLong(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialize chunk data to buffer. Attempted to write entry long[" + i + "]: " + value + " at writer index: " + bufferIndex + " with size " + 8, e);
            }
            int newIndex = buffer.writerIndex();
            if (newIndex - bufferIndex == 8) continue;
            throw new IllegalStateException("Attempted to write a long to a packet buffer at index: " + bufferIndex + " with expected end of size of 8, however found " + (newIndex - bufferIndex) + " instead.");
        }
        int postIndex = buffer.writerIndex();
        int difference = arrayIndex + expectedArraySize - postIndex;
        if (difference != 0) {
            throw new IllegalStateException("Potentially leaking or pruning data... Started index at " + arrayIndex + " with expected end being " + arrayIndex + expectedArraySize + " but got " + postIndex + " with a difference of " + difference);
        }
        return buffer;
    }
}

