/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.type.NotePitches;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.processor.common.NoteUtils;
import org.spongepowered.common.data.type.SpongeNotePitch;

public final class NotePitchRegistryModule
implements CatalogRegistryModule<NotePitch> {
    @RegisterCatalog(value=NotePitches.class)
    private final Map<String, NotePitch> notePitchMap = new HashMap<String, NotePitch>();

    @Override
    public Optional<NotePitch> getById(String id) {
        return Optional.ofNullable(this.notePitchMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<NotePitch> getAll() {
        return ImmutableList.copyOf(this.notePitchMap.values());
    }

    @Override
    public void registerDefaults() {
        for (SpongeNotePitch pitch : NoteUtils.pitchMappings.values()) {
            this.notePitchMap.put(pitch.getId().toLowerCase(Locale.ENGLISH), pitch);
        }
    }
}

