/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.spongepowered.api.item.inventory.InventoryTransformation;
import org.spongepowered.api.item.inventory.InventoryTransformations;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.entity.MainPlayerInventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.query.ReverseTransformation;
import org.spongepowered.common.item.inventory.query.SpongeQueryTransformation;
import org.spongepowered.common.registry.type.item.QueryOperationRegistryModule;

@RegistrationDependency(value={QueryOperationRegistryModule.class})
public class TransformationRegistryModule
implements RegistryModule {
    public static TransformationRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        this.register("NO_OP", Collections.emptyList());
        this.register("PLAYER_MAIN_HOTBAR_FIRST", Arrays.asList(QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class), QueryOperationTypes.INVENTORY_TYPE.of(MainPlayerInventory.class)));
        this.register("REVERSE", new ReverseTransformation());
        this.register("EMPTY", EmptyInventoryImpl::new);
    }

    private void register(String field, List<QueryOperation> operations) {
        SpongeQueryTransformation transformation = new SpongeQueryTransformation(operations);
        this.register(field, transformation);
    }

    private void register(String field, InventoryTransformation transformation) {
        try {
            InventoryTransformations.class.getDeclaredField(field).set(null, transformation);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private TransformationRegistryModule() {
    }

    private static final class Holder {
        static final TransformationRegistryModule INSTANCE = new TransformationRegistryModule();

        private Holder() {
        }
    }
}

