/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.common.interfaces.text.IMixinTextComponent;

public class TextComponentIterator
extends UnmodifiableIterator<ITextComponent> {
    private IMixinTextComponent component;
    private Iterator<ITextComponent> children;
    @Nullable
    private Iterator<ITextComponent> currentChildIterator;

    public TextComponentIterator(IMixinTextComponent component) {
        this.component = (IMixinTextComponent)Preconditions.checkNotNull((Object)component, (Object)"component");
    }

    public TextComponentIterator(Iterator<ITextComponent> children) {
        this.children = (Iterator)Preconditions.checkNotNull(children, (Object)"children");
        if (this.children.hasNext()) {
            this.setCurrentChildIterator();
        }
    }

    public boolean hasNext() {
        return this.component != null || this.currentChildIterator != null && this.currentChildIterator.hasNext();
    }

    public ITextComponent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.component != null) {
            return this.init();
        }
        ITextComponent result = this.currentChildIterator.next();
        if (!this.currentChildIterator.hasNext() && this.children.hasNext()) {
            this.setCurrentChildIterator();
        }
        return result;
    }

    private ITextComponent init() {
        this.children = this.component.childrenIterator();
        IMixinTextComponent result = this.component;
        this.component = null;
        if (this.children.hasNext()) {
            this.setCurrentChildIterator();
        }
        return result;
    }

    private void setCurrentChildIterator() {
        this.currentChildIterator = ((IMixinTextComponent)this.children.next()).withChildren().iterator();
    }
}

