/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.management.MBeanServer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.LoggingCategory;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.interfaces.IMixinTrackable;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entityactivation.interfaces.IModData_Activation;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.teleport.ConfigTeleportHelperFilter;

public class SpongeHooks {
    private static Object2LongMap<CollisionWarning> recentWarnings = new Object2LongOpenHashMap();

    public static void logInfo(String msg, Object ... args) {
        SpongeImpl.getLogger().info(MessageFormat.format(msg, args));
    }

    public static void logWarning(String msg, Object ... args) {
        SpongeImpl.getLogger().warn(MessageFormat.format(msg, args));
    }

    public static void logSevere(String msg, Object ... args) {
        SpongeImpl.getLogger().fatal(MessageFormat.format(msg, args));
    }

    public static void logStack(SpongeConfig<? extends GeneralConfigBase> config) {
        if (config.getConfig().getLogging().logWithStackTraces()) {
            Throwable ex = new Throwable();
            ex.fillInStackTrace();
            SpongeImpl.getLogger().catching(Level.INFO, ex);
        }
    }

    public static void logEntityDeath(Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)entity.field_70170_p);
        if (config.getConfig().getLogging().entityDeathLogging()) {
            SpongeHooks.logInfo("Dim: {0} setDead(): {1}", ((IMixinWorldServer)entity.field_70170_p).getDimensionId(), entity);
            SpongeHooks.logStack(config);
        }
    }

    public static void logEntityDespawn(Entity entity, String reason) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)entity.field_70170_p);
        if (config.getConfig().getLogging().entityDespawnLogging()) {
            SpongeHooks.logInfo("Dim: {0} Despawning ({1}): {2}", ((IMixinWorldServer)entity.field_70170_p).getDimensionId(), reason, entity);
            SpongeHooks.logStack(config);
        }
    }

    public static void logEntitySpawn(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        String spawnName = entity.func_70005_c_();
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)entity.field_70170_p);
        if (config.getConfig().getLogging().entitySpawnLogging()) {
            SpongeHooks.logInfo("SPAWNED " + spawnName + " [World: {2}][DimId: {3}]", entity.field_70170_p.func_72912_H().func_76065_j(), ((IMixinWorldServer)entity.field_70170_p).getDimensionId());
            SpongeHooks.logStack(config);
        }
    }

    public static void logBlockTrack(net.minecraft.world.World world, Block block, BlockPos pos, User user, boolean allowed) {
        if (world.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)world);
        if (config.getConfig().getLogging().blockTrackLogging() && allowed) {
            SpongeHooks.logInfo("Tracking Block [RootCause: {0}][World: {1}][Block: {2}][Pos: {3}]", user.getName(), world.func_72912_H().func_76065_j() + "(" + ((IMixinWorldServer)world).getDimensionId() + ")", ((BlockType)block).getId(), pos);
            SpongeHooks.logStack(config);
        } else if (config.getConfig().getLogging().blockTrackLogging() && !allowed) {
            SpongeHooks.logInfo("Blacklisted! Unable to track Block [RootCause: {0}][World: {1}][DimId: {2}][Block: {3}][Pos: {4}]", user.getName(), world.func_72912_H().func_76065_j(), ((IMixinWorldServer)world).getDimensionId(), ((BlockType)block).getId(), pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p());
        }
    }

    public static void logBlockAction(net.minecraft.world.World world, @Nullable BlockChange type, Transaction<BlockSnapshot> transaction) {
        if (world.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)world);
        LoggingCategory logging = config.getConfig().getLogging();
        if (type != null && type.allowsLogging(logging)) {
            SpongeHooks.logInfo("Block " + type.name() + " [World: {2}][DimId: {3}][OriginalState: {4}][NewState: {5}]", world.func_72912_H().func_76065_j(), ((IMixinWorldServer)world).getDimensionId(), transaction.getOriginal().getState(), transaction.getFinal().getState());
            SpongeHooks.logStack(config);
        }
    }

    public static void logChunkLoad(net.minecraft.world.World world, Vector3i chunkPos) {
        if (world.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)world);
        if (config.getConfig().getLogging().chunkLoadLogging()) {
            SpongeHooks.logInfo("Load Chunk At [{0}] ({1}, {2})", ((IMixinWorldServer)world).getDimensionId(), chunkPos.getX(), chunkPos.getZ());
            SpongeHooks.logStack(config);
        }
    }

    public static void logChunkUnload(net.minecraft.world.World world, Vector3i chunkPos) {
        if (world.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)world);
        if (config.getConfig().getLogging().chunkUnloadLogging()) {
            SpongeHooks.logInfo("Unload Chunk At [{0}] ({1}, {2})", ((IMixinWorldServer)world).getDimensionId(), chunkPos.getX(), chunkPos.getZ());
            SpongeHooks.logStack(config);
        }
    }

    public static void logChunkGCQueueUnload(WorldServer world, Chunk chunk) {
        if (world.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig(world);
        if (config.getConfig().getLogging().chunkGCQueueUnloadLogging()) {
            SpongeHooks.logInfo("Chunk GC Queued Chunk At [{0}] ({1}, {2} for unload)", ((IMixinWorldServer)world).getDimensionId(), chunk.field_76635_g, chunk.field_76647_h);
            SpongeHooks.logStack(config);
        }
    }

    public static void logExploitSignCommandUpdates(EntityPlayer player, TileEntity te, String command) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)player.field_70170_p);
        if (config.getConfig().getLogging().logExploitSignCommandUpdates) {
            SpongeHooks.logInfo("[EXPLOIT] Player ''{0}'' attempted to exploit sign in world ''{1}'' located at ''{2}'' with command ''{3}''", player.func_70005_c_(), te.func_145831_w().func_72912_H().func_76065_j(), te.func_174877_v().func_177958_n() + ", " + te.func_174877_v().func_177956_o() + ", " + te.func_174877_v().func_177952_p(), command);
            SpongeHooks.logStack(config);
        }
    }

    public static void logExploitItemNameOverflow(EntityPlayer player, int length) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)player.field_70170_p);
        if (config.getConfig().getLogging().logExploitItemStackNameOverflow) {
            SpongeHooks.logInfo("[EXPLOIT] Player ''{0}'' attempted to send a creative itemstack update with a display name length of ''{1}'' (Max allowed length is 32767). This has been blocked to avoid server overflow.", player.func_70005_c_(), length);
            SpongeHooks.logStack(config);
        }
    }

    public static void logExploitRespawnInvisibility(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)player.field_70170_p);
        if (config.getConfig().getLogging().logExploitRespawnInvisibility) {
            SpongeHooks.logInfo("[EXPLOIT] Player ''{0}'' attempted to perform a respawn invisibility exploit to surrounding players.", player.func_70005_c_());
            SpongeHooks.logStack(config);
        }
    }

    public static boolean checkBoundingBoxSize(Entity entity, AxisAlignedBB aabb) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)entity.field_70170_p);
        if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer || entity instanceof IEntityMultiPart) {
            return false;
        }
        int maxBoundingBoxSize = config.getConfig().getEntity().getMaxBoundingBoxSize();
        if (maxBoundingBoxSize <= 0) {
            return false;
        }
        int x = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int x1 = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int y = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int y1 = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int z = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int z1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        int size = Math.abs(x1 - x) * Math.abs(y1 - y) * Math.abs(z1 - z);
        if (size > maxBoundingBoxSize) {
            SpongeHooks.logWarning("Entity being removed for bounding box restrictions", new Object[0]);
            SpongeHooks.logWarning("BB Size: {0} > {1} avg edge: {2}", size, maxBoundingBoxSize, aabb.func_72320_b());
            SpongeHooks.logWarning("Motion: ({0}, {1}, {2})", entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            SpongeHooks.logWarning("Calculated bounding box: {0}", aabb);
            SpongeHooks.logWarning("Entity bounding box: {0}", entity.func_70046_E());
            SpongeHooks.logWarning("Entity: {0}", entity);
            NBTTagCompound tag = new NBTTagCompound();
            entity.func_189511_e(tag);
            SpongeHooks.logWarning("Entity NBT: {0}", tag);
            SpongeHooks.logStack(config);
            entity.func_70106_y();
            return true;
        }
        return false;
    }

    public static boolean checkEntitySpeed(Entity entity, double x, double y, double z) {
        double distance;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)entity.field_70170_p);
        int maxSpeed = config.getConfig().getEntity().getMaxSpeed();
        if (maxSpeed > 0 && (distance = x * x + z * z) > (double)maxSpeed && !entity.func_184218_aH()) {
            if (config.getConfig().getLogging().logEntitySpeedRemoval()) {
                SpongeHooks.logInfo("Speed violation: {0} was over {1} - Removing Entity: {2}", distance, maxSpeed, entity);
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase livingBase = (EntityLivingBase)entity;
                    SpongeHooks.logInfo("Entity Motion: ({0}, {1}, {2}) Move Strafing: {3} Move Forward: {4}", entity.field_70159_w, entity.field_70181_x, entity.field_70179_y, Float.valueOf(livingBase.field_70702_br), Float.valueOf(livingBase.field_191988_bg));
                }
                if (config.getConfig().getLogging().logWithStackTraces()) {
                    SpongeHooks.logInfo("Move offset: ({0}, {1}, {2})", x, y, z);
                    SpongeHooks.logInfo("Motion: ({0}, {1}, {2})", entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                    SpongeHooks.logInfo("Entity: {0}", entity);
                    NBTTagCompound tag = new NBTTagCompound();
                    entity.func_189511_e(tag);
                    SpongeHooks.logInfo("Entity NBT: {0}", tag);
                    SpongeHooks.logStack(config);
                }
            }
            if (entity instanceof EntityPlayer) {
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                return false;
            }
            entity.field_70128_L = true;
            return false;
        }
        return true;
    }

    public static void logEntitySize(Entity entity, List list) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        SpongeConfig<? extends GeneralConfigBase> config = SpongeHooks.getWorldConfig((WorldServer)entity.field_70170_p);
        if (!config.getConfig().getLogging().logEntityCollisionChecks()) {
            return;
        }
        int collisionWarnSize = config.getConfig().getEntity().getMaxCollisionSize();
        if (list == null) {
            return;
        }
        if (collisionWarnSize > 0 && entity.func_130014_f_().func_73046_m().func_71259_af() % 10 == 0 && list.size() >= collisionWarnSize) {
            CollisionWarning warning = new CollisionWarning(entity.field_70170_p, entity);
            if (recentWarnings.containsKey((Object)warning)) {
                long lastWarned = (Long)recentWarnings.get((Object)warning);
                if (MinecraftServer.func_130071_aq() - lastWarned < 30000L) {
                    return;
                }
            }
            recentWarnings.put((Object)warning, System.currentTimeMillis());
            SpongeHooks.logWarning("Entity collision > {0, number} at: {1}", collisionWarnSize, entity);
        }
    }

    public static void dumpHeap(File file, boolean live) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            Method m = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(hotspotMBean, file.getPath(), live);
        }
        catch (Throwable t) {
            SpongeHooks.logSevere("Could not write heap to {0}", file);
        }
    }

    public static void enableThreadContentionMonitoring() {
        if (!SpongeImpl.getGlobalConfig().getConfig().getDebug().isEnableThreadContentionMonitoring()) {
            return;
        }
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        mbean.setThreadContentionMonitoringEnabled(true);
    }

    public static SpongeConfig<? extends GeneralConfigBase> getWorldConfig(WorldServer world) {
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)world;
        return mixinWorldServer.getWorldConfig();
    }

    public static SpongeConfig<? extends GeneralConfigBase> getSpongeConfig(Path dimensionPath, String worldFolder) {
        Optional<World> optWorld;
        if (dimensionPath == null) {
            return SpongeImpl.getGlobalConfig();
        }
        if (worldFolder != null && (optWorld = SpongeImpl.getGame().getServer().getWorld(worldFolder)).isPresent()) {
            return ((IMixinWorldServer)((Object)optWorld.get())).getWorldConfig();
        }
        Path dimConfPath = dimensionPath.resolve("dimension.conf");
        SpongeConfig dimConfig = new SpongeConfig(SpongeConfig.Type.DIMENSION, dimConfPath, "sponge", SpongeImpl.getGlobalConfig());
        if (worldFolder != null) {
            Path worldConfPath = dimensionPath.resolve(worldFolder).resolve("world.conf");
            return new SpongeConfig(SpongeConfig.Type.WORLD, worldConfPath, "sponge", dimConfig);
        }
        return dimConfig;
    }

    public static void refreshActiveConfigs() {
        for (BlockType blockType : BlockTypeRegistryModule.getInstance().getAll()) {
            if (blockType instanceof IModData_Collisions) {
                ((IModData_Collisions)((Object)blockType)).requiresCollisionsCacheRefresh(true);
            }
            if (!(blockType instanceof IMixinTrackable)) continue;
            ((IMixinBlock)((Object)blockType)).initializeTrackerState();
        }
        for (TileEntityType tileEntityType : TileEntityTypeRegistryModule.getInstance().getAll()) {
            ((SpongeTileEntityType)tileEntityType).initializeTrackerState();
        }
        for (EntityType entityType : EntityTypeRegistryModule.getInstance().getAll()) {
            ((SpongeEntityType)entityType).initializeTrackerState();
        }
        for (WorldServer world : WorldManager.getWorlds()) {
            SpongeConfig<? extends GeneralConfigBase> worldConfig = SpongeHooks.getWorldConfig(world);
            worldConfig.reload();
            ((IMixinWorldServer)world).updateConfigCache();
            for (Entity entity : world.field_72996_f) {
                if (entity instanceof IModData_Activation) {
                    ((IModData_Activation)entity).requiresActivationCacheRefresh(true);
                }
                if (entity instanceof IModData_Collisions) {
                    ((IModData_Collisions)entity).requiresCollisionsCacheRefresh(true);
                }
                if (!(entity instanceof IMixinTrackable)) continue;
                ((IMixinTrackable)entity).refreshCache();
            }
            for (TileEntity tileEntity : world.field_147482_g) {
                if (tileEntity instanceof IModData_Activation) {
                    ((IModData_Activation)tileEntity).requiresActivationCacheRefresh(true);
                }
                if (!(tileEntity instanceof IMixinTrackable)) continue;
                ((IMixinTrackable)tileEntity).refreshCache();
            }
        }
        ConfigTeleportHelperFilter.invalidateCache();
    }

    public static void populatePluginsInMetricsConfig() {
        boolean globalState = SpongeImpl.getGlobalConfig().getConfig().getMetricsCategory().isGloballyEnabled();
        Map<String, Boolean> entries = SpongeImpl.getGlobalConfig().getConfig().getMetricsCategory().getPluginPermissions();
        Sponge.getPluginManager().getPlugins().stream().filter(SpongeImplHooks.getPluginFilterPredicate()).forEach(plugin -> entries.putIfAbsent(plugin.getId(), globalState));
        try {
            SpongeHooks.savePluginsInMetricsConfig(entries).get();
        }
        catch (InterruptedException | ExecutionException e) {
            SpongeImpl.getLogger().warn("Could not populate the plugin list for metric collection", (Throwable)e);
        }
    }

    public static CompletableFuture<CommentedConfigurationNode> savePluginsInMetricsConfig(Map<String, Boolean> entries) {
        return SpongeImpl.getGlobalConfig().updateSetting("metrics.plugin-permissions", entries, new TypeToken<Map<String, Boolean>>(){});
    }

    public static String getFriendlyCauseName(Cause cause) {
        String causedBy = "Unknown";
        Object rootCause = cause.root();
        if (rootCause instanceof User) {
            User user = (User)rootCause;
            causedBy = user.getName();
        } else if (rootCause instanceof EntityItem) {
            EntityItem item = (EntityItem)rootCause;
            causedBy = item.func_92059_d().func_82833_r();
        } else if (rootCause instanceof Entity) {
            Entity causeEntity = (Entity)rootCause;
            causedBy = causeEntity.func_70005_c_();
        } else if (rootCause instanceof BlockSnapshot) {
            BlockSnapshot snapshot = (BlockSnapshot)rootCause;
            causedBy = snapshot.getState().getType().getId();
        } else if (rootCause instanceof CatalogType) {
            CatalogType type = (CatalogType)rootCause;
            causedBy = type.getId();
        } else if (rootCause instanceof PluginContainer) {
            PluginContainer plugin = (PluginContainer)rootCause;
            causedBy = plugin.getId();
        } else {
            causedBy = rootCause.getClass().getName();
        }
        return causedBy;
    }

    private static class CollisionWarning {
        public BlockPos blockPos;
        public int dimensionId;

        public CollisionWarning(net.minecraft.world.World world, Entity entity) {
            this.dimensionId = ((IMixinWorldServer)world).getDimensionId();
            this.blockPos = new BlockPos(entity.field_70176_ah, entity.field_70162_ai, entity.field_70164_aj);
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof CollisionWarning) || otherObj == null) {
                return false;
            }
            CollisionWarning other = (CollisionWarning)otherObj;
            return other.dimensionId == this.dimensionId && other.blockPos.equals((Object)this.blockPos);
        }

        public int hashCode() {
            return this.blockPos.hashCode() + this.dimensionId;
        }
    }
}

