/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.common.util.gen.AbstractBiomeBuffer;
import org.spongepowered.common.util.gen.ByteArrayImmutableBiomeBuffer;
import org.spongepowered.common.world.extent.MutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.MutableBiomeViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBiomeVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;

public final class ByteArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements MutableBiomeVolume {
    private boolean detached;
    private final byte[] biomes;

    private void checkOpen() {
        Preconditions.checkState((!this.detached ? 1 : 0) != 0, (Object)"trying to use buffer after it's closed");
    }

    public ByteArrayMutableBiomeBuffer(Vector3i start, Vector3i size) {
        this(new byte[size.getX() * size.getZ()], start, size);
    }

    public ByteArrayMutableBiomeBuffer(byte[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        this.checkOpen();
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)z)] = (byte)Biome.func_185362_a((Biome)((Biome)biome));
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkOpen();
        this.checkRange(x, y, z);
        byte biomeId = this.biomes[this.getIndex(x, z)];
        BiomeType biomeType = (BiomeType)Biome.func_185357_a((int)(biomeId & 0xFF));
        return biomeType == null ? BiomeTypes.OCEAN : biomeType;
    }

    public byte[] detach() {
        this.checkOpen();
        this.detached = true;
        return this.biomes;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void reuse(Vector3i start) {
        Preconditions.checkState((boolean)this.detached, (Object)"Cannot reuse while still in use");
        this.start = (Vector3i)Preconditions.checkNotNull((Object)start, (Object)"start");
        this.end = this.start.add(this.size).sub(Vector3i.ONE);
        Arrays.fill(this.biomes, (byte)0);
        this.detached = false;
    }

    @Override
    public MutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new MutableBiomeViewTransform(this, transform);
    }

    @Override
    public MutableBiomeVolumeWorker<? extends MutableBiomeVolume> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<ByteArrayMutableBiomeBuffer>(this);
    }

    @Override
    public UnmodifiableBiomeVolume getUnmodifiableBiomeView() {
        return new UnmodifiableBiomeVolumeWrapper(this);
    }

    @Override
    public MutableBiomeVolume getBiomeCopy(StorageType type) {
        this.checkOpen();
        switch (type) {
            case STANDARD: {
                return new ByteArrayMutableBiomeBuffer((byte[])this.biomes.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBiomeVolume getImmutableBiomeCopy() {
        this.checkOpen();
        return new ByteArrayImmutableBiomeBuffer(this.biomes, this.start, this.size);
    }
}

