/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.ChunkPrimer;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.util.gen.ArrayImmutableBlockBuffer;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

public final class ChunkPrimerBuffer
extends AbstractBlockBuffer
implements MutableBlockVolume {
    private final ChunkPrimer chunkPrimer;

    public ChunkPrimerBuffer(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        super(ChunkPrimerBuffer.getBlockStart(chunkX, chunkZ), SpongeChunkLayout.CHUNK_SIZE);
        this.chunkPrimer = chunkPrimer;
    }

    private static Vector3i getBlockStart(int chunkX, int chunkZ) {
        return SpongeChunkLayout.instance.forceToWorld(chunkX, 0, chunkZ);
    }

    @Override
    public BlockPalette getPalette() {
        return GlobalPalette.instance;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return (BlockState)this.chunkPrimer.func_177856_a(x & 0xF, y, z & 0xF);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkRange(x, y, z);
        this.chunkPrimer.func_177855_a(x & 0xF, y, z & 0xF, (IBlockState)block);
        return true;
    }

    @Override
    public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform(this, transform);
    }

    @Override
    public MutableBlockVolumeWorker<? extends MutableBlockVolume> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker<ChunkPrimerBuffer>(this);
    }

    @Override
    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper(this);
    }

    @Override
    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ArrayMutableBlockBuffer((BlockPalette)GlobalPalette.instance, this.start, this.size, (char[])this.chunkPrimer.field_177860_a.clone());
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBlockVolume getImmutableBlockCopy() {
        return new ArrayImmutableBlockBuffer((BlockPalette)GlobalPalette.instance, this.start, this.size, this.chunkPrimer.field_177860_a);
    }
}

