/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen;

import co.aikar.timings.Timing;
import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.interfaces.world.gen.IGenerationPopulator;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.world.gen.SpongeChunkGenerator;
import org.spongepowered.common.world.gen.WorldGenConstants;

public final class SpongeGenerationPopulator
implements GenerationPopulator,
IGenerationPopulator {
    private final IChunkGenerator chunkGenerator;
    private final World world;
    @Nullable
    private Timing timing;
    @Nullable
    private Chunk cachedChunk = null;

    public static GenerationPopulator of(World world, IChunkGenerator chunkGenerator) {
        if (WorldGenConstants.isValid(chunkGenerator, GenerationPopulator.class)) {
            return (GenerationPopulator)chunkGenerator;
        }
        if (chunkGenerator instanceof SpongeChunkGenerator) {
            return ((SpongeChunkGenerator)chunkGenerator).getBaseGenerationPopulator();
        }
        return new SpongeGenerationPopulator(world, chunkGenerator);
    }

    private SpongeGenerationPopulator(World world, IChunkGenerator chunkGenerator) {
        this.world = (World)Preconditions.checkNotNull((Object)world, (Object)"world");
        this.chunkGenerator = (IChunkGenerator)Preconditions.checkNotNull((Object)chunkGenerator, (Object)"chunkGenerator");
    }

    @Override
    public void populate(org.spongepowered.api.world.World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        this.getTimingsHandler().startTimingIfSync();
        Vector3i min = buffer.getBlockMin();
        Vector3i max = buffer.getBlockMax();
        int minChunkX = GenericMath.floor((double)min.getX() / 16.0);
        int minChunkZ = GenericMath.floor((double)min.getZ() / 16.0);
        int maxChunkX = GenericMath.floor((double)max.getX() / 16.0);
        int maxChunkZ = GenericMath.floor((double)max.getZ() / 16.0);
        WorldGenConstants.disableLighting();
        if (minChunkX == maxChunkX && minChunkZ == maxChunkZ) {
            this.cachedChunk = this.chunkGenerator.func_185932_a(minChunkX, minChunkZ);
            this.placeChunkInBuffer(this.cachedChunk, buffer, minChunkX, minChunkZ);
        } else {
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    Chunk generated = this.chunkGenerator.func_185932_a(chunkX, chunkZ);
                    this.placeChunkInBuffer(generated, buffer, chunkX, chunkZ);
                }
            }
        }
        WorldGenConstants.enableLighting();
        this.getTimingsHandler().stopTimingIfSync();
    }

    private void placeChunkInBuffer(Chunk chunk, MutableBlockVolume buffer, int chunkX, int chunkZ) {
        ExtendedBlockStorage[] blockStorage;
        int xOffset = chunkX * 16;
        int zOffset = chunkZ * 16;
        Vector3i minBound = buffer.getBlockMin();
        Vector3i maxBound = buffer.getBlockMax();
        int xInChunkStart = Math.max(0, minBound.getX() - xOffset);
        int yStart = Math.max(0, minBound.getY());
        int zInChunkStart = Math.max(0, minBound.getZ() - zOffset);
        int xInChunkEnd = Math.min(15, maxBound.getX() - xOffset);
        int yEnd = Math.min(255, maxBound.getY());
        int zInChunkEnd = Math.min(15, maxBound.getZ() - zOffset);
        for (ExtendedBlockStorage miniChunk : blockStorage = chunk.func_76587_i()) {
            if (miniChunk == null) continue;
            int yOffset = miniChunk.func_76662_d();
            int yInChunkStart = Math.max(0, yStart);
            int yInChunkEnd = Math.min(15, yEnd);
            for (int xInChunk = xInChunkStart; xInChunk <= xInChunkEnd; ++xInChunk) {
                for (int yInChunk = yInChunkStart; yInChunk <= yInChunkEnd; ++yInChunk) {
                    for (int zInChunk = zInChunkStart; zInChunk <= zInChunkEnd; ++zInChunk) {
                        buffer.setBlock(xOffset + xInChunk, yOffset + yInChunk, zOffset + zInChunk, (BlockState)miniChunk.func_177485_a(xInChunk, yInChunk, zInChunk));
                    }
                }
            }
        }
    }

    public Chunk getCachedChunk() {
        return this.cachedChunk;
    }

    public IChunkGenerator getChunkGenerator() {
        return this.chunkGenerator;
    }

    public void clearCachedChunk() {
        this.cachedChunk = null;
    }

    public IChunkGenerator getHandle(World targetWorld) {
        if (!this.world.equals(targetWorld)) {
            throw new IllegalArgumentException("Cannot reassign internal generator from world " + SpongeGenerationPopulator.getWorldName(this.world) + " to world " + SpongeGenerationPopulator.getWorldName(targetWorld));
        }
        return this.chunkGenerator;
    }

    private static String getWorldName(World world) {
        return ((org.spongepowered.api.world.World)world).getName();
    }

    @Override
    public Timing getTimingsHandler() {
        if (this.timing == null) {
            String modId = SpongeImplHooks.getModIdFromClass(this.chunkGenerator.getClass());
            if (!modId.equals("")) {
                modId = modId + ":";
            }
            this.timing = SpongeTimingsFactory.ofSafe("chunkGenerator - " + modId + this.chunkGenerator.getClass().getName());
        }
        return this.timing;
    }
}

