/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Stage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.potion.PotionType;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.command.MinecraftCommandWrapper;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.entity.ai.SpongeEntityAICommonSuperclass;
import org.spongepowered.common.event.registry.SpongeGameRegistryRegisterEvent;
import org.spongepowered.common.inject.SpongeGuice;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.interfaces.IMixinServerCommandManager;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.item.recipe.crafting.DelegateSpongeCraftingRecipe;
import org.spongepowered.common.item.recipe.crafting.SpongeCraftingRecipeRegistry;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.registry.type.effect.PotionEffectTypeRegistryModule;
import org.spongepowered.common.registry.type.effect.SoundRegistryModule;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.registry.type.item.EnchantmentRegistryModule;
import org.spongepowered.common.registry.type.item.PotionTypeRegistryModule;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.service.permission.SpongeContextCalculator;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.sql.SqlServiceImpl;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;
import org.spongepowered.mod.SpongeCoremod;
import org.spongepowered.mod.SpongeModMetadata;
import org.spongepowered.mod.event.SpongeEventHooks;
import org.spongepowered.mod.inject.SpongeForgeModule;
import org.spongepowered.mod.interfaces.IMixinVillagerProfession;
import org.spongepowered.mod.network.SpongeModMessageHandler;
import org.spongepowered.mod.plugin.MetaModContainer;
import org.spongepowered.mod.plugin.SpongeModPluginContainer;
import org.spongepowered.mod.registry.SpongeForgeModuleRegistry;
import org.spongepowered.mod.registry.SpongeForgeVillagerRegistry;
import org.spongepowered.mod.registry.SpongeGameData;
import org.spongepowered.mod.service.world.SpongeChunkTicketManager;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

public class SpongeMod
extends MetaModContainer {
    public static SpongeMod instance;
    @Nullable
    public static Thread SERVER_THREAD;
    @Nullable
    public static Thread CLIENT_THREAD;
    @Nullable
    public static Side side;
    private static boolean hasChecked;
    private static boolean isClientSide;
    @Inject
    private SpongeGame game;
    @Inject
    private SpongeScheduler scheduler;
    @Inject
    private Logger logger;
    private LoadController controller;
    private File modFile;
    private static String EXPECTED_CERTIFICATE_FINGERPRINT;
    private Certificate certificate;
    private @MonotonicNonNull URL updateJsonUrl;

    public static boolean isClientRunningServerAndServerThread() {
        if (SpongeMod.isClient()) {
            Thread current = Thread.currentThread();
            if (CLIENT_THREAD != null && current == CLIENT_THREAD) {
                return false;
            }
            if (SERVER_THREAD != null) {
                return SERVER_THREAD == current;
            }
            NetworkManager client = FMLCommonHandler.instance().getClientToServerNetworkManager();
            return client != null && client.func_150724_d() && client.func_150731_c();
        }
        return false;
    }

    public static boolean isClient() {
        if (!hasChecked) {
            hasChecked = true;
            try {
                Class.forName("net.minecraft.server.dedicated.DedicatedServer", false, SpongeMod.class.getClassLoader());
                isClientSide = false;
            }
            catch (ClassNotFoundException e) {
                isClientSide = true;
            }
        }
        return isClientSide;
    }

    public SpongeMod() throws Exception {
        super(SpongeModMetadata.getSpongeForgeMetadata());
        this.readMetadata();
        ModContainerFactory.instance().registerContainerType(Type.getType(Plugin.class), SpongeModPluginContainer.class);
        instance = this;
        side = FMLCommonHandler.instance().getSide();
        this.modFile = SpongeCoremod.modFile;
        Stage stage = SpongeGuice.getInjectorStage((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? Stage.DEVELOPMENT : Stage.PRODUCTION);
        SpongeImpl.getLogger().info("Creating injector in stage '{}'", (Object)stage);
        Guice.createInjector(stage, new SpongeModule(), new SpongeForgeModule());
        Sponge.getPluginManager().getPlugin("sponge").ifPresent(SpongeImpl::setSpongePlugin);
        SpongeImpl.getRegistry().preRegistryInit();
        SpongeGameData.addRegistryCallback(ForgeRegistries.BLOCKS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey(obj);
            if (key == null || ((IMixinBlock)obj).isDummy()) {
                return;
            }
            BlockTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (BlockType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.ITEMS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey(obj);
            if (key == null) {
                return;
            }
            ItemTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (ItemType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.ENCHANTMENTS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.ENCHANTMENTS.getKey(obj);
            if (key == null) {
                return;
            }
            EnchantmentRegistryModule.getInstance().registerFromGameData(key.toString(), (EnchantmentType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.POTION_TYPES, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.POTION_TYPES.getKey(obj);
            if (key == null) {
                return;
            }
            PotionTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (PotionType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.POTIONS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.POTIONS.getKey(obj);
            if (key == null) {
                return;
            }
            PotionEffectTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (PotionEffectType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.VILLAGER_PROFESSIONS, (owner, manager, id, obj, oldObj) -> {
            IMixinVillagerProfession mixinProfession = (IMixinVillagerProfession)obj;
            if (mixinProfession.getSpongeProfession().isPresent()) {
                return;
            }
            SpongeProfession spongeProfession = new SpongeProfession(id, mixinProfession.getId(), mixinProfession.getProfessionName());
            mixinProfession.setSpongeProfession(spongeProfession);
            ProfessionRegistryModule.getInstance().registerAdditionalCatalog(spongeProfession);
            for (VillagerRegistry.VillagerCareer villagerCareer : mixinProfession.getCareers()) {
                SpongeForgeVillagerRegistry.fromNative(villagerCareer);
            }
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.SOUND_EVENTS, (owner, manager, id, obj, oldObj) -> SoundRegistryModule.inst().registerAdditionalCatalog((SoundType)obj));
        SpongeForgeModuleRegistry.registerForgeData();
        this.game.getEventManager().registerListeners((Object)this, (Object)this);
        SpongeImpl.getInternalPlugins().add((PluginContainer)ForgeModContainer.getInstance());
    }

    private void readMetadata() {
        ModMetadata metadata = this.getMetadata();
        if (!Strings.isNullOrEmpty((String)metadata.updateJSON)) {
            try {
                this.updateJsonUrl = new URL(metadata.updateJSON);
            }
            catch (MalformedURLException e) {
                this.getLogger().warn("Encountered an exception while constructing version check data URL", e);
            }
        }
    }

    public Object getMod() {
        return this;
    }

    public File getSource() {
        return this.modFile;
    }

    public LoadController getController() {
        return this.controller;
    }

    private <T> void registerService(Class<T> serviceClass, T serviceImpl) {
        SpongeImpl.getGame().getServiceManager().setProvider(SpongeImpl.getPlugin(), serviceClass, serviceImpl);
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        this.controller = controller;
        return true;
    }

    public Class<?> getCustomResourcePackClass() {
        if (this.getSource().isDirectory()) {
            return FMLFolderResourcePack.class;
        }
        return FMLFileResourcePack.class;
    }

    @Subscribe
    public void onStateEvent(FMLStateEvent event) {
        if (!event.getClass().equals(FMLConstructionEvent.class)) {
            SpongeImpl.postEvent((Event)event, true);
        }
    }

    @Subscribe
    public void construction(FMLConstructionEvent event) {
        this.checkFingerprint();
    }

    private void checkFingerprint() {
        Certificate[] certificates = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getCertificates();
        ImmutableList fingerprints = CertificateHelper.getFingerprints((Certificate[])certificates);
        if (Launch.blackboard.getOrDefault("fml.deobfuscatedEnvironment", false).booleanValue()) {
            SpongeImpl.getLogger().debug("Skipping certificate fingerprint check - we're in a deobfuscated environment");
            return;
        }
        if (!EXPECTED_CERTIFICATE_FINGERPRINT.isEmpty()) {
            if (!fingerprints.contains(EXPECTED_CERTIFICATE_FINGERPRINT)) {
                PrettyPrinter pp = new PrettyPrinter(60).wrapTo(60);
                pp.add("Uh oh! Something's fishy here.").centre().hr();
                pp.addWrapped("It looks like we didn't find the certificate fingerprint we were expecting.", new Object[0]);
                pp.add();
                pp.add("%s: %s", "Expected Fingerprint", EXPECTED_CERTIFICATE_FINGERPRINT);
                if (fingerprints.size() > 1) {
                    pp.add("Actual Fingerprints:");
                    for (String fingerprint : fingerprints) {
                        pp.add(" - %s", fingerprint);
                    }
                } else {
                    pp.add("%s: %s", "Actual Fingerprint", fingerprints.get(0));
                }
                pp.log(SpongeImpl.getLogger(), Level.ERROR);
            } else {
                this.certificate = certificates[fingerprints.indexOf(EXPECTED_CERTIFICATE_FINGERPRINT)];
            }
        } else {
            SpongeImpl.getLogger().warn("There's no certificate fingerprint available");
        }
    }

    public Certificate getSigningCertificate() {
        return this.certificate;
    }

    @Subscribe
    public void onPreInit(FMLPreInitializationEvent event) {
        try {
            SpongeImpl.getGame().getEventManager().registerListeners(SpongeImpl.getPlugin().getInstance().get(), SpongeInternalListeners.getInstance());
            this.registerService(ChunkTicketManager.class, new SpongeChunkTicketManager());
            SpongeBootstrap.initializeServices();
            SpongeBootstrap.initializeCommands();
            SpongeImpl.getRegistry().preInit();
            SpongeModMessageHandler.init();
            Preconditions.checkArgument((boolean)Class.forName("org.spongepowered.api.entity.ai.task.AbstractAITask").getSuperclass().equals(SpongeEntityAICommonSuperclass.class));
            MinecraftForge.EVENT_BUS.register((Object)new SpongeEventHooks());
            SpongeInternalListeners.getInstance().registerServiceCallback(PermissionService.class, input -> input.registerContextCalculator(new SpongeContextCalculator()));
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.EVENT_BUS.register((Object)this.game.getChannelRegistrar());
            if (event.getSide().isServer()) {
                SpongeHooks.enableThreadContentionMonitoring();
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.scheduler.tickSyncScheduler();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_71387_A() && event.phase == TickEvent.Phase.START) {
            this.scheduler.tickSyncScheduler();
        }
    }

    @SubscribeEvent
    public void onRecipeRegister(final RegistryEvent.Register<IRecipe> event) {
        SpongeGameRegistryRegisterEvent<CraftingRecipe> registerEvent = new SpongeGameRegistryRegisterEvent<CraftingRecipe>(Sponge.getCauseStackManager().getCurrentCause(), CraftingRecipe.class, (AdditionalCatalogRegistryModule)SpongeCraftingRecipeRegistry.getInstance()){

            @Override
            public void register(CraftingRecipe catalogType) {
                Object recipe = catalogType instanceof IRecipe ? (IRecipe)catalogType : new DelegateSpongeCraftingRecipe(catalogType);
                recipe.setRegistryName(new ResourceLocation(catalogType.getId()));
                event.getRegistry().register((IForgeRegistryEntry)recipe);
            }
        };
        SpongeImpl.postEvent(registerEvent);
    }

    @SubscribeEvent
    public void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        for (EntityTypeRegistryModule.FutureRegistration registration : EntityTypeRegistryModule.getInstance().getCustomEntities()) {
            EntityRegistry.registerModEntity((ResourceLocation)registration.name, registration.type, (String)registration.name.func_110623_a(), (int)registration.id, (Object)registration.name.func_110624_b(), (int)0, (int)0, (boolean)false);
        }
    }

    @Subscribe
    public void onInitialization(FMLInitializationEvent event) {
        try {
            SpongeImpl.getRegistry().init();
            if (!this.game.getServiceManager().provide(PermissionService.class).isPresent()) {
                SpongePermissionService service = new SpongePermissionService(this.game);
                this.game.getServiceManager().setProvider((Object)this, PermissionService.class, service);
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @Subscribe
    public void onPostInitialization(FMLPostInitializationEvent event) {
        try {
            SpongeImpl.getRegistry().postInit();
            SpongeHooks.populatePluginsInMetricsConfig();
            SpongeImpl.getConfigSaveManager().flush();
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @Subscribe
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        SpongeImpl.getRegistry().registerAdditionals();
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            StaticMixinForgeHelper.registerCustomEntity(entry);
        }
    }

    @Subscribe
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        try {
            try {
                ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerLowPriorityCommands(this.game);
            }
            catch (Throwable t) {
                this.controller.errorOccurred((ModContainer)this, t);
            }
            ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerEarlyCommands(this.game);
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
        if (this.game.getPlatform().getType().isClient()) {
            WorldManager.registerVanillaTypesAndDimensions();
            ((SqlServiceImpl)this.game.getServiceManager().provideUnchecked(SqlService.class)).buildConnectionCache();
        }
    }

    @Subscribe
    public void onServerStarted(FMLServerStartedEvent event) {
        SpongeImpl.getConfigSaveManager().flush();
        Sponge.getServer().getConsole().getContainingCollection();
        SpongePlayerDataHandler.init();
    }

    @Subscribe
    public void onServerStopped(FMLServerStoppedEvent event) throws IOException {
        try {
            CommandManager service = this.game.getCommandManager();
            service.getCommands().stream().filter(mapping -> mapping.getCallable() instanceof MinecraftCommandWrapper).forEach(service::removeMapping);
            ((SqlServiceImpl)this.game.getServiceManager().provideUnchecked(SqlService.class)).close();
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
        SpongeImpl.getConfigSaveManager().flush();
        if (this.game.getPlatform().getType().isClient()) {
            WorldManager.unregisterAllWorldSettings();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public URL getUpdateUrl() {
        return this.updateJsonUrl;
    }

    static {
        hasChecked = false;
        isClientSide = false;
        EXPECTED_CERTIFICATE_FINGERPRINT = "";
    }
}

