/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.util.SpongeHooks;

public class SpongeEventHooks {
    @SubscribeEvent
    public void onChunkWatchEvent(ChunkWatchEvent event) {
        IMixinEntity spongeEntity = (IMixinEntity)event.getPlayer();
        if (spongeEntity.isTeleporting()) {
            spongeEntity.getTeleportVehicle().func_184188_bt().add(event.getPlayer());
            spongeEntity.setTeleportVehicle(null);
            spongeEntity.setIsTeleporting(false);
        }
    }

    @SubscribeEvent
    public void onEntityDeathEvent(LivingDeathEvent event) {
        SpongeHooks.logEntityDeath(event.getEntity());
    }

    @SubscribeEvent
    public void onForceChunk(ForgeChunkManager.ForceChunkEvent event) {
        Chunk chunk = ((IMixinChunkProviderServer)event.getTicket().world.func_72863_F()).getLoadedChunkWithoutMarkingActive(event.getLocation().field_77276_a, event.getLocation().field_77275_b);
        if (chunk != null) {
            ((IMixinChunk)chunk).setPersistedChunk(true);
        }
    }

    @SubscribeEvent
    public void onUnforceChunk(ForgeChunkManager.UnforceChunkEvent event) {
        Chunk chunk = ((IMixinChunkProviderServer)event.getTicket().world.func_72863_F()).getLoadedChunkWithoutMarkingActive(event.getLocation().field_77276_a, event.getLocation().field_77275_b);
        if (chunk != null) {
            ((IMixinChunk)chunk).setPersistedChunk(false);
        }
    }
}

