/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.common.event.RegisteredListener;
import org.spongepowered.mod.event.ForgeToSpongeEventData;

public class SpongeToForgeEventData {
    private final org.spongepowered.api.event.Event spongeEvent;
    private final Class<? extends Event> forgeClass;
    private final RegisteredListener.Cache listenerCache;
    private final boolean useCauseStackManager;
    private Event forgeEvent;

    public SpongeToForgeEventData(org.spongepowered.api.event.Event spongeEvent, Class<? extends Event> forgeClass, RegisteredListener.Cache cache, boolean useCauseStackManager) {
        this.spongeEvent = spongeEvent;
        this.forgeClass = forgeClass;
        this.listenerCache = cache;
        this.useCauseStackManager = useCauseStackManager;
    }

    public SpongeToForgeEventData(ForgeToSpongeEventData eventData) {
        this.spongeEvent = eventData.getSpongeEvent();
        this.forgeClass = eventData.getForgeEvent().getClass();
        this.listenerCache = eventData.getSpongeListenerCache();
        this.useCauseStackManager = eventData.useCauseStackManager();
        this.forgeEvent = eventData.getForgeEvent();
    }

    public boolean useCauseStackManager() {
        return this.useCauseStackManager;
    }

    public org.spongepowered.api.event.Event getSpongeEvent() {
        return this.spongeEvent;
    }

    public Event getForgeEvent() {
        return this.forgeEvent;
    }

    public RegisteredListener.Cache getSpongeListenerCache() {
        return this.listenerCache;
    }

    public Class<? extends Event> getForgeClass() {
        return this.forgeClass;
    }

    public void setForgeEvent(Event event) {
        this.forgeEvent = event;
    }

    public void propagateCancelled() {
        if (this.spongeEvent instanceof Cancellable && this.forgeEvent.isCancelable() && !((Cancellable)((Object)this.spongeEvent)).isCancelled()) {
            ((Cancellable)((Object)this.spongeEvent)).setCancelled(this.forgeEvent.isCanceled());
        }
    }
}

