/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.item.inventory.fabric;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.item.inventory.lens.Fabric;

public class IItemHandlerFabric
implements Fabric {
    private final IItemHandler inventory;
    private static Set<Class> setStackUnsupported = new HashSet<Class>();

    public IItemHandlerFabric(IItemHandler inventory) {
        this.inventory = inventory;
    }

    @Override
    public Collection<?> allInventories() {
        return ImmutableSet.of((Object)this.inventory);
    }

    public IItemHandler get(int index) {
        return this.inventory;
    }

    @Override
    public ItemStack getStack(int index) {
        return this.inventory.getStackInSlot(index);
    }

    @Override
    public void setStack(int index, ItemStack stack) {
        IItemHandlerFabric.setIItemHandlerStack(this.inventory, index, stack);
    }

    @Override
    public int getMaxStackSize() {
        return this.inventory.getSlotLimit(0);
    }

    @Override
    public Translation getDisplayName() {
        return new FixedTranslation(this.getClass().getName());
    }

    @Override
    public int getSize() {
        return this.inventory.getSlots();
    }

    @Override
    public void clear() {
        if (this.inventory instanceof IItemHandlerModifiable) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ((IItemHandlerModifiable)this.inventory).setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void markDirty() {
    }

    private static void setIItemHandlerStack(IItemHandler handler, int index, ItemStack stack) {
        if (setStackUnsupported.contains(handler.getClass())) {
            return;
        }
        if (handler instanceof IItemHandlerModifiable) {
            try {
                ((IItemHandlerModifiable)handler).setStackInSlot(index, stack);
            }
            catch (RuntimeException e) {
                setStackUnsupported.add(handler.getClass());
                SpongeImpl.getLogger().warn("Modded Inventory refused setting slot. Sponge cannot handle modified slot transactions for this type of Inventory. " + handler.getClass());
            }
            return;
        }
        ItemStack prev = handler.getStackInSlot(index);
        if (!prev.func_190926_b()) {
            ItemStack extracted;
            for (int cnt = prev.func_190916_E(); cnt > 0; cnt -= extracted.func_190916_E()) {
                extracted = handler.extractItem(index, cnt, false);
                if (extracted.func_190916_E() != 0) continue;
                prev = handler.getStackInSlot(index);
                if (prev.func_190926_b()) break;
                setStackUnsupported.add(handler.getClass());
                SpongeImpl.getLogger().warn("Modded Inventory refused extraction. Sponge cannot handle modified slot transactions for this type of Inventory. " + handler.getClass());
                return;
            }
        }
        prev = stack;
        while (!stack.func_190926_b() && prev != (stack = handler.insertItem(index, stack, false)) && prev.func_190916_E() != stack.func_190916_E()) {
            prev = stack;
        }
    }
}

