/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.common;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.SpongeCommonEventFactory;

@Mixin(value={SpongeCommonEventFactory.class}, remap=false)
public abstract class MixinSpongeCommonEventFactory {
    @Inject(method={"callDestructEntityEventDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onCallDestructEntityEventDeath(EntityLivingBase entity, DamageSource source, boolean isMainThread, CallbackInfoReturnable<Optional<DestructEntityEvent.Death>> cir) {
        if (ForgeHooks.onLivingDeath((EntityLivingBase)entity, (DamageSource)source)) {
            cir.setReturnValue(Optional.empty());
        }
    }

    @Inject(method={"toInventory"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onToInventory(IInventory inventory, CallbackInfoReturnable<Inventory> cir) {
        if (!(inventory instanceof Inventory)) {
            cir.setReturnValue((Inventory)new InvWrapper(inventory));
        }
    }

    @Overwrite
    public static void callPostPlayerRespawnEvent(EntityPlayerMP playerMP, boolean conqueredEnd) {
        FMLCommonHandler.instance().firePlayerRespawnEvent((EntityPlayer)playerMP, conqueredEnd);
    }
}

