/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.mod.plugin.DependencyHandler;
import org.spongepowered.plugin.meta.PluginDependency;

@Mixin(value={ModContainer.class})
@Implements(value={@Interface(iface=PluginContainer.class, prefix="plugin$")})
public interface MixinModContainer
extends ModContainer {
    default public String getId() {
        return (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.getModId()), (Object)"modid");
    }

    default public Optional<String> plugin$getVersion() {
        String version = Strings.emptyToNull((String)this.getVersion());
        if (version != null && (version.equalsIgnoreCase("unknown") || version.equalsIgnoreCase("dev"))) {
            version = null;
        }
        return Optional.ofNullable(version);
    }

    default public Optional<String> getDescription() {
        ModMetadata meta = this.getMetadata();
        return meta != null ? Optional.ofNullable(Strings.emptyToNull((String)meta.description)) : Optional.empty();
    }

    default public Optional<String> getUrl() {
        ModMetadata meta = this.getMetadata();
        return meta != null ? Optional.ofNullable(Strings.emptyToNull((String)meta.url)) : Optional.empty();
    }

    default public List<String> getAuthors() {
        ModMetadata meta = this.getMetadata();
        return meta != null ? ImmutableList.copyOf((Collection)meta.authorList) : ImmutableList.of();
    }

    default public Set<PluginDependency> plugin$getDependencies() {
        return DependencyHandler.collectDependencies(this);
    }

    default public Optional<PluginDependency> getDependency(String id) {
        return Optional.ofNullable(DependencyHandler.findDependency(this, id));
    }

    default public Optional<Path> plugin$getSource() {
        File source = this.getSource();
        if (source != null) {
            return Optional.of(source.toPath());
        }
        return Optional.empty();
    }

    default public Optional<?> getInstance() {
        return Optional.ofNullable(this.getMod());
    }
}

