/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common.eventhandler;

import co.aikar.timings.Timing;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventExceptionHandler;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.RegisteredListener;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.mod.SpongeModPlatform;
import org.spongepowered.mod.event.ForgeToSpongeEventData;
import org.spongepowered.mod.event.ForgeToSpongeEventFactory;
import org.spongepowered.mod.event.SpongeModEventManager;
import org.spongepowered.mod.event.SpongeToForgeEventData;
import org.spongepowered.mod.interfaces.IMixinASMEventHandler;
import org.spongepowered.mod.interfaces.IMixinEventBus;

@NonnullByDefault
@Mixin(value={EventBus.class}, remap=false)
public abstract class MixinEventBus
implements IMixinEventBus {
    private static Map<IEventListener, Class<? extends net.minecraftforge.fml.common.eventhandler.Event>> forgeListenerRegistry = new HashMap<IEventListener, Class<? extends net.minecraftforge.fml.common.eventhandler.Event>>();
    private static Set<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>> forgeListenerEventClasses = new HashSet<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>>();
    @Shadow
    @Final
    private int busID;
    @Shadow
    private IEventExceptionHandler exceptionHandler;

    @Nullable
    private PhaseContext<?> preEventPhaseCheck(IMixinASMEventHandler listener, net.minecraftforge.fml.common.eventhandler.Event event) {
        if (!SpongeImplHooks.isMainThread()) {
            return null;
        }
        if (event instanceof TickEvent.WorldTickEvent) {
            TickEvent.WorldTickEvent worldTickEvent = (TickEvent.WorldTickEvent)event;
            World world = worldTickEvent.world;
            if (world == null || ((IMixinWorld)world).isFake()) {
                return null;
            }
            if (worldTickEvent.phase == TickEvent.Phase.START) {
                return ((ListenerPhaseContext)PluginPhase.Listener.PRE_WORLD_TICK_LISTENER.createPhaseContext().source(listener)).event(event);
            }
            if (worldTickEvent.phase == TickEvent.Phase.END) {
                return ((ListenerPhaseContext)PluginPhase.Listener.POST_WORLD_TICK_LISTENER.createPhaseContext().source(listener)).event(event);
            }
        }
        if (event instanceof TickEvent.ServerTickEvent) {
            TickEvent.ServerTickEvent serverTickEvent = (TickEvent.ServerTickEvent)event;
            if (serverTickEvent.phase == TickEvent.Phase.START) {
                return ((ListenerPhaseContext)PluginPhase.Listener.PRE_SERVER_TICK_LISTENER.createPhaseContext().source(listener)).event(event);
            }
            if (serverTickEvent.phase == TickEvent.Phase.END) {
                return ((ListenerPhaseContext)PluginPhase.Listener.POST_SERVER_TICK_LISTENER.createPhaseContext().source(listener)).event(event);
            }
        }
        if (SpongeImplHooks.isMainThread() && !this.isIgnoredEvent(event) && listener.getContainer() != null && PhaseTracker.getInstance().getCurrentState().allowsEventListener()) {
            return PluginPhase.Listener.GENERAL_LISTENER.createPhaseContext().source(listener.getContainer());
        }
        return null;
    }

    private boolean isEventAllowed(net.minecraftforge.fml.common.eventhandler.Event event) {
        if (event instanceof LivingDropsEvent) {
            return false;
        }
        if (event instanceof WorldEvent.Save) {
            return false;
        }
        return !(event instanceof WorldEvent.Unload);
    }

    private boolean isClientPlatform() {
        return SpongeModPlatform.staticGetExecutionType().isClient();
    }

    private boolean isIgnoredEvent(net.minecraftforge.fml.common.eventhandler.Event event) {
        if (event instanceof TickEvent) {
            return true;
        }
        if (event instanceof EntityEvent.CanUpdate) {
            return true;
        }
        if (event instanceof GetCollisionBoxesEvent) {
            return true;
        }
        if (event instanceof AttachCapabilitiesEvent) {
            return true;
        }
        if (event instanceof OreDictionary.OreRegisterEvent) {
            return true;
        }
        return event instanceof FluidRegistry.FluidRegisterEvent;
    }

    private boolean isTimedEvent(net.minecraftforge.fml.common.eventhandler.Event event) {
        return !(event instanceof AttachCapabilitiesEvent);
    }

    @Overwrite
    public boolean post(net.minecraftforge.fml.common.eventhandler.Event event) {
        return this.post(event, false);
    }

    @Override
    public boolean post(SpongeToForgeEventData eventData) {
        boolean result = this.post(eventData.getForgeEvent(), true);
        eventData.propagateCancelled();
        return result;
    }

    @Override
    public boolean post(net.minecraftforge.fml.common.eventhandler.Event event, boolean forced) {
        int index;
        Class<? extends Event> spongeEventClass = null;
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        if (!forced && SpongeImpl.isInitialized() && SpongeImplHooks.isMainThread() && !this.isIgnoredEvent(event)) {
            RegisteredListener.Cache listenerCache;
            if (!this.isEventAllowed(event)) {
                return false;
            }
            spongeEventClass = ForgeToSpongeEventFactory.getSpongeClass(event);
            if (spongeEventClass != null && !(listenerCache = ((SpongeModEventManager)Sponge.getEventManager()).getHandlerCache(spongeEventClass)).getListeners().isEmpty()) {
                ForgeToSpongeEventData forgeEventData = new ForgeToSpongeEventData(event, listeners);
                forgeEventData.setSpongeListenerCache(listenerCache);
                return ((SpongeModEventManager)SpongeImpl.getGame().getEventManager()).post(forgeEventData);
            }
        }
        try {
            for (index = 0; index < listeners.length; ++index) {
                IEventListener listener = listeners[index];
                if (SpongeImpl.isInitialized() && listener instanceof IMixinASMEventHandler) {
                    try (Timing timing = this.isTimedEvent(event) ? ((IMixinASMEventHandler)listener).getTimingsHandler() : null;
                         PhaseContext<?> context = this.preEventPhaseCheck((IMixinASMEventHandler)listener, event);){
                        if (context != null) {
                            context.buildAndSwitch();
                        }
                        if (timing != null) {
                            timing.startTimingIfSync();
                        }
                        listener.invoke(event);
                        continue;
                    }
                }
                listener.invoke(event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException((EventBus)this, event, listeners, index, throwable);
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
        return event.isCancelable() && event.isCanceled();
    }

    @Redirect(method={"register(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/reflect/Method;Lnet/minecraftforge/fml/common/ModContainer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/eventhandler/ListenerList;register(ILnet/minecraftforge/fml/common/eventhandler/EventPriority;Lnet/minecraftforge/fml/common/eventhandler/IEventListener;)V", remap=false))
    public void onRegister(ListenerList list, int id, EventPriority priority, IEventListener listener, Class<? extends net.minecraftforge.fml.common.eventhandler.Event> eventType, Object target, Method method, ModContainer owner) {
        list.register(id, priority, listener);
        SpongeModEventManager manager = (SpongeModEventManager)SpongeImpl.getGame().getEventManager();
        for (Class clazz : TypeToken.of(eventType).getTypes().rawTypes()) {
            ImmutableCollection spongeEvents = manager.forgeToSpongeEventMapping.get((Object)clazz);
            if (spongeEvents == null) continue;
            for (Class event : spongeEvents) {
                manager.checker.registerListenerFor(event);
            }
        }
        forgeListenerRegistry.put(listener, eventType);
        forgeListenerEventClasses.add(eventType);
    }

    @Redirect(method={"unregister"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/eventhandler/ListenerList;unregisterAll(ILnet/minecraftforge/fml/common/eventhandler/IEventListener;)V", remap=false))
    public void onUnregisterListener(int id, IEventListener listener) {
        ListenerList.unregisterAll((int)id, (IEventListener)listener);
        SpongeModEventManager manager = (SpongeModEventManager)SpongeImpl.getGame().getEventManager();
        for (Class<? extends net.minecraftforge.fml.common.eventhandler.Event> clazz : TypeToken.of((Class)((Class)Preconditions.checkNotNull(forgeListenerRegistry.remove(listener)))).getTypes().rawTypes()) {
            ImmutableCollection spongeEvents = manager.forgeToSpongeEventMapping.get((Object)clazz);
            if (spongeEvents == null) continue;
            for (Class clazz2 : spongeEvents) {
                manager.checker.unregisterListenerFor(clazz2);
            }
        }
        Iterator<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>> it = forgeListenerEventClasses.iterator();
        while (it.hasNext()) {
            Class<? extends net.minecraftforge.fml.common.eventhandler.Event> clazz;
            clazz = it.next();
            boolean found = false;
            for (Map.Entry entry : forgeListenerRegistry.entrySet()) {
                if (!clazz.equals(entry.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
        }
    }

    @Override
    public Set<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>> getEventListenerClassList() {
        return forgeListenerEventClasses;
    }

    @Override
    public int getBusID() {
        return this.busID;
    }
}

