/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge.fluids;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.registries.IRegistryDelegate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.extra.fluid.FluidStack;
import org.spongepowered.api.extra.fluid.FluidStackSnapshot;
import org.spongepowered.api.extra.fluid.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.extra.fluid.SpongeFluidStackSnapshotBuilder;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;

@Mixin(value={net.minecraftforge.fluids.FluidStack.class}, remap=false)
public class MixinFluidStack
implements FluidStack {
    @Shadow
    public int amount;
    @Shadow
    @Nullable
    public NBTTagCompound tag;
    @Shadow
    private IRegistryDelegate<Fluid> fluidDelegate;

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        Optional<DataProcessor<?, ?>> optional = DataUtil.getWildProcessor(containerClass);
        if (optional.isPresent()) {
            return optional.get().from(this);
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        Optional<DataProcessor<?, ?>> optional = DataUtil.getWildProcessor(containerClass);
        if (optional.isPresent()) {
            return optional.get().createFrom(this);
        }
        if (this instanceof IMixinCustomDataHolder) {
            return ((IMixinCustomDataHolder)((Object)this)).getCustom(containerClass);
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends DataManipulator<?, ?>> holderClass) {
        Optional<DataProcessor<?, ?>> optional = DataUtil.getWildProcessor(holderClass);
        return optional.isPresent() && optional.get().supports(this);
    }

    @Override
    public <E> DataTransactionResult offer(Key<? extends BaseValue<E>> key, E value) {
        Optional optional = DataUtil.getBaseValueProcessor(key);
        if (optional.isPresent()) {
            return optional.get().offerToStore(this, value);
        }
        if (this instanceof IMixinCustomDataHolder) {
            return ((IMixinCustomDataHolder)((Object)this)).offerCustom(key, value);
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult offer(DataManipulator<?, ?> valueContainer, MergeFunction function) {
        Optional<DataProcessor> optional = DataUtil.getWildDataProcessor(valueContainer.getClass());
        if (optional.isPresent()) {
            return optional.get().set(this, valueContainer, (MergeFunction)Preconditions.checkNotNull((Object)function));
        }
        if (this instanceof IMixinCustomDataHolder) {
            return ((IMixinCustomDataHolder)((Object)this)).offerCustom(valueContainer, function);
        }
        return DataTransactionResult.failResult(valueContainer.getValues());
    }

    @Override
    public DataTransactionResult offer(Iterable<DataManipulator<?, ?>> valueContainers) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (DataManipulator<?, ?> manipulator : valueContainers) {
            DataTransactionResult result = this.offer(manipulator);
            if (!result.getRejectedData().isEmpty()) {
                builder.reject(result.getRejectedData());
            }
            if (!result.getReplacedData().isEmpty()) {
                builder.replace(result.getReplacedData());
            }
            if (!result.getSuccessfulData().isEmpty()) {
                builder.success(result.getSuccessfulData());
            }
            DataTransactionResult.Type type = result.getType();
            builder.result(type);
            switch (type) {
                case UNDEFINED: 
                case ERROR: 
                case CANCELLED: {
                    return builder.build();
                }
            }
        }
        return builder.build();
    }

    @Override
    public DataTransactionResult remove(Class<? extends DataManipulator<?, ?>> containerClass) {
        Optional<DataProcessor<?, ?>> optional = DataUtil.getWildProcessor(containerClass);
        if (optional.isPresent()) {
            return optional.get().remove(this);
        }
        if (this instanceof IMixinCustomDataHolder) {
            return ((IMixinCustomDataHolder)((Object)this)).removeCustom(containerClass);
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        Optional<ValueProcessor<?, ?>> optional = DataUtil.getWildValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            return optional.get().removeFrom(this);
        }
        if (this instanceof IMixinCustomDataHolder) {
            return ((IMixinCustomDataHolder)((Object)this)).removeCustom(key);
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        if (result.getReplacedData().isEmpty() && result.getSuccessfulData().isEmpty()) {
            return DataTransactionResult.successNoData();
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (ImmutableValue<?> replaced : result.getReplacedData()) {
            builder.absorbResult(this.offer(replaced));
        }
        for (ImmutableValue<?> successful : result.getSuccessfulData()) {
            builder.absorbResult(this.remove(successful));
        }
        return builder.build();
    }

    @Override
    public DataTransactionResult copyFrom(DataHolder that, MergeFunction function) {
        return this.offer(that.getContainers(), function);
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        return Collections.emptyList();
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        Optional optional = DataUtil.getBaseValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            return optional.get().getValueFromContainer(this);
        }
        return Optional.empty();
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        Optional optional = DataUtil.getValueProcessor((Key)Preconditions.checkNotNull(key));
        if (optional.isPresent()) {
            return optional.get().getApiValueFromContainer(this);
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        Optional<ValueProcessor<?, ?>> optional = DataUtil.getWildValueProcessor((Key)Preconditions.checkNotNull(key));
        return optional.isPresent() && optional.get().supports(this);
    }

    @Override
    public DataHolder copy() {
        net.minecraftforge.fluids.FluidStack fluidStack = new net.minecraftforge.fluids.FluidStack((Fluid)this.fluidDelegate.get(), this.amount, this.tag);
        return (DataHolder)fluidStack;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.of();
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return ImmutableSet.of();
    }

    @Override
    public FluidType getFluid() {
        return (FluidType)this.fluidDelegate.get();
    }

    @Override
    public int getVolume() {
        return this.amount;
    }

    @Override
    public FluidStack setVolume(int volume) {
        Preconditions.checkArgument((volume > 0 ? 1 : 0) != 0);
        this.amount = volume;
        return this;
    }

    @Override
    public FluidStackSnapshot createSnapshot() {
        return (FluidStackSnapshot)new SpongeFluidStackSnapshotBuilder().from(this).build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(DataQueries.FLUID_TYPE, (Object)((Fluid)this.fluidDelegate.get()).getName()).set(DataQueries.FLUID_VOLUME, (Object)this.getVolume());
        if (this.tag != null) {
            container.set(DataQueries.UNSAFE_NBT, (Object)NbtTranslator.getInstance().translateFrom(this.tag));
        }
        return container;
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return this.getFluid().getProperty(propertyClass);
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return this.getFluid().getApplicableProperties();
    }
}

