/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.interfaces.world.IMixinWorld;

@Mixin(value={World.class}, priority=999)
public abstract class MixinWorld
implements IMixinWorld {
    private boolean callingWorldEvent = false;
    @Shadow
    @Final
    public WorldProvider field_73011_w;
    @Shadow
    @Final
    public boolean field_72995_K;
    @Shadow
    protected MapStorage field_72988_C;

    @Shadow
    public abstract IChunkProvider func_72863_F();

    @Shadow
    public abstract boolean func_175678_i(BlockPos var1);

    @Shadow
    public abstract IBlockState func_180495_p(BlockPos var1);

    @Shadow
    public abstract int func_175642_b(EnumSkyBlock var1, BlockPos var2);

    @Overwrite
    private int func_175638_a(BlockPos pos, EnumSkyBlock lightType) {
        if (lightType == EnumSkyBlock.SKY && this.func_175678_i(pos)) {
            return 15;
        }
        IBlockState blockState = this.func_180495_p(pos);
        int blockLight = SpongeImplHooks.getChunkPosLight(blockState, (World)this, pos);
        int i = lightType == EnumSkyBlock.SKY ? 0 : blockLight;
        int j = SpongeImplHooks.getBlockLightOpacity(blockState, (IBlockAccess)((World)this), pos);
        if (j >= 15 && blockLight > 0) {
            j = 1;
        }
        if (j < 1) {
            j = 1;
        }
        if (j >= 15) {
            return 0;
        }
        if (i >= 14) {
            return i;
        }
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            int k = this.func_175642_b(lightType, blockpos) - j;
            if (k > i) {
                i = k;
            }
            if (i < 14) continue;
            return i;
        }
        return i;
    }

    @Inject(method={"getWorldInfo"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetWorldInfo(CallbackInfoReturnable<WorldInfo> cir) {
        if (this.field_73011_w.getDimension() != 0 && this.callingWorldEvent) {
            cir.setReturnValue(DimensionManager.getWorld((int)0).func_72912_H());
        }
    }

    @Inject(method={"getMapStorage"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetMapStorage(CallbackInfoReturnable<MapStorage> cir) {
        WorldServer overworld;
        if (!(this.field_72995_K || this.field_72988_C != null && this.field_73011_w.getDimension() == 0 || (overworld = DimensionManager.getWorld((int)0)) == null)) {
            cir.setReturnValue(overworld.func_175693_T());
        }
    }

    @Override
    public void setCallingWorldEvent(boolean flag) {
        this.callingWorldEvent = flag;
    }
}

