/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.world;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.MixinWorld;
import org.spongepowered.common.world.gen.SpongeChunkGenerator;
import org.spongepowered.common.world.gen.SpongeWorldGenerator;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.mod.world.gen.SpongeChunkGeneratorForge;

@Mixin(value={WorldServer.class}, priority=1001)
public abstract class MixinWorldServer
extends MixinWorld
implements org.spongepowered.api.world.World,
IMixinWorldServer {
    @Shadow
    public abstract ChunkProviderServer func_72863_F();

    @Override
    public Integer getDimensionId() {
        return this.field_73011_w.getDimension();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/DimensionManager;setWorld(ILnet/minecraft/world/WorldServer;Lnet/minecraft/server/MinecraftServer;)V", remap=false))
    private void redirectSetWorld(int id, WorldServer world, MinecraftServer server) {
    }

    @Redirect(method={"canMineBlockBody"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;isBlockProtected(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/EntityPlayer;)Z"))
    private boolean isSpongeBlockProtected(MinecraftServer server, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (server.func_175579_a(worldIn, pos, playerIn)) {
            return true;
        }
        if (!this.isFake() && SpongeImplHooks.isMainThread()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(playerIn.func_184607_cu()));
                boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)this, pos, (Object)playerIn).isCancelled();
                return bl;
            }
        }
        return false;
    }

    @Override
    @Overwrite
    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        if (super.func_175660_a(player, pos)) {
            return true;
        }
        if (!this.isFake() && SpongeImplHooks.isMainThread()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(player.func_184607_cu()));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)this, pos, (Object)player).isCancelled();
                return bl;
            }
        }
        return false;
    }

    @Override
    public SpongeChunkGenerator createChunkGenerator(SpongeWorldGenerator newGenerator) {
        return new SpongeChunkGeneratorForge((World)this, newGenerator.getBaseGenerationPopulator(), newGenerator.getBiomeGenerator());
    }

    @Override
    public CompletableFuture<Optional<Chunk>> loadChunkAsync(int cx, int cy, int cz, boolean shouldGenerate) {
        if (shouldGenerate) {
            return org.spongepowered.api.world.World.super.loadChunkAsync(cx, cy, cz, true);
        }
        if (!SpongeChunkLayout.instance.isValidChunk(cx, cy, cz)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Optional<Chunk>> future = new CompletableFuture<Optional<Chunk>>();
        this.func_72863_F().loadChunk(cx, cz, () -> future.complete(Optional.ofNullable((Chunk)this.func_72863_F().func_186026_b(cx, cz))));
        return future;
    }
}

