/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import java.io.IOException;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmHelper
implements Opcodes {
    private static Method defineClass;

    public static Class<?> createClass(ClassNode node) {
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        byte[] bytes = writer.toByteArray();
        return AsmHelper.createClassFromBytes(node.name.replace('/', '.'), bytes);
    }

    public static Class<?> createClassFromBytes(String name, byte[] bytes) {
        if (defineClass == null) {
            defineClass = AsmHelper.getDefineClassMethod();
        }
        try {
            return (Class)defineClass.invoke((Object)AsmHelper.class.getClassLoader(), name.replace('/', '.'), bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getDefineClassMethod() {
        Method defineClass = null;
        try {
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return defineClass;
    }

    public static <T> Class<? extends T> createSubClass(Class<T> superClass, String nameSuffix, int constructorParams) {
        ClassNode superNode = AsmHelper.createClassNode(superClass);
        MethodNode constructor = AsmHelper.findConstructor(superNode, constructorParams);
        String className = superClass.getName().replace('.', '/') + "_" + nameSuffix.replace(":", "_");
        ClassWriter cw = new ClassWriter(0);
        cw.visit(51, 33, className, null, Type.getInternalName(superClass), null);
        MethodVisitor mv = cw.visitMethod(1, constructor.name, constructor.desc, null, null);
        int[] opcodes = AsmHelper.createLoadOpcodes(constructor);
        for (int i = 0; i < opcodes.length; ++i) {
            mv.visitVarInsn(opcodes[i], i);
        }
        mv.visitMethodInsn(183, Type.getInternalName(superClass), constructor.name, constructor.desc, false);
        mv.visitInsn(177);
        mv.visitMaxs(constructorParams + 1, constructorParams + 1);
        mv.visitEnd();
        byte[] byteCode = cw.toByteArray();
        return AsmHelper.createClassFromBytes(className, byteCode);
    }

    static int[] createLoadOpcodes(MethodNode method) {
        Type[] argumentTypes = Type.getArgumentTypes((String)method.desc);
        int[] opcodes = new int[argumentTypes.length + 1];
        opcodes[0] = 25;
        for (int i = 0; i < argumentTypes.length; ++i) {
            opcodes[i + 1] = argumentTypes[i].getOpcode(21);
        }
        return opcodes;
    }

    static MethodNode findConstructor(ClassNode node, int numParams) {
        for (MethodNode method : node.methods) {
            Type[] argumentTypes = Type.getArgumentTypes((String)method.desc);
            if (!method.name.equals("<init>") || argumentTypes.length != numParams) continue;
            return method;
        }
        return null;
    }

    public static ClassNode createClassNode(Class<?> clazz) {
        ClassNode node = new ClassNode();
        try {
            String fileName = clazz.getName().replace('.', '/') + ".class";
            ClassReader reader = new ClassReader(clazz.getClassLoader().getResourceAsStream(fileName));
            reader.accept((ClassVisitor)node, 0);
            return node;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't create ClassNode for class " + clazz.getName());
        }
    }
}

